/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterPrioritySideButtonWidget;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterPropertyTypes;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockModeSideButtonWidget;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterContainerMenu;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.VisibleToTheAutocrafterManagerSideButtonWidget;
import com.ultramega.cabletiers.common.support.AbstractAdvancedFilterScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class TieredAutocrafterScreen
extends AbstractBaseScreen<TieredAutocrafterContainerMenu>
implements AutocrafterContainerMenu.Listener {
    private static final Component EMPTY_PATTERN_SLOT = IdentifierUtil.createTranslationAsHeading((String)"gui", (String)"autocrafter.empty_pattern_slot");
    private static final Component CHAINED = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.chained");
    private static final Component CHAINED_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.chained.help");
    private static final Component CHAINED_HEAD_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.chained.head_help");
    private static final Component NOT_CHAINED = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.not_chained");
    private static final Component NOT_CHAINED_HELP = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.not_chained.help");
    private static final Component EDIT = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.edit_name");
    private static final Component CURRENTLY_LOCKED = IdentifierUtil.createTranslation((String)"gui", (String)"autocrafter.currently_locked");
    private static final ResourceLocation NAME_BACKGROUND = IdentifierUtil.createIdentifier((String)"widget/autocrafter_name");
    private static final List<String> CRAFTER_NAME_HISTORY = new ArrayList<String>();
    private final Inventory playerInventory;
    private final CableTiers tier;
    @Nullable
    private LockModeSideButtonWidget lockModeSideButtonWidget;
    @Nullable
    private EditBox nameField;
    @Nullable
    private Button editButton;
    private boolean editName;

    public TieredAutocrafterScreen(TieredAutocrafterContainerMenu menu, Inventory playerInventory, Component title, CableTiers tier) {
        super((AbstractContainerMenu)menu, playerInventory, new TextMarquee(title, TieredAutocrafterScreen.getTitleMaxWidth(menu)));
        this.playerInventory = playerInventory;
        this.tier = tier;
        switch (tier) {
            case ELITE: {
                this.inventoryLabelY = 60;
                this.imageHeight = 155;
                break;
            }
            case ULTRA: {
                this.inventoryLabelY = 96;
                this.imageHeight = 191;
                break;
            }
            case MEGA: 
            case CREATIVE: {
                this.inventoryLabelY = 132;
                this.imageHeight = 227;
            }
        }
        this.imageWidth = this.hasUpgrades() ? 210 : 176;
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.editName) {
            graphics.blitSprite(NAME_BACKGROUND, this.leftPos + 7, this.topPos + 5, 162, 12);
        }
    }

    protected void init() {
        super.init();
        ((TieredAutocrafterContainerMenu)this.getMenu()).setListener(this);
        this.tryAddLockModeSideButton();
        this.addSideButton(new AutocrafterPrioritySideButtonWidget((ClientProperty<Integer>)((TieredAutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.PRIORITY), this.playerInventory, (Screen)this));
        this.addSideButton((AbstractSideButtonWidget)new VisibleToTheAutocrafterManagerSideButtonWidget((ClientProperty<Boolean>)((TieredAutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER)));
        this.nameField = new SearchFieldWidget(this.font, this.leftPos + 8 + 1, this.topPos + 6 + 1, 153, new History(CRAFTER_NAME_HISTORY));
        this.nameField.setValue(this.title.getString());
        this.nameField.setBordered(false);
        this.nameField.setCanLoseFocus(false);
        this.addWidget((GuiEventListener)this.nameField);
        this.editButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)EDIT, button -> this.setEditName(true)).pos(this.getEditButtonX(), this.topPos + this.titleLabelY - 3).size(TieredAutocrafterScreen.getEditButtonWidth(), 14).build());
        this.editButton.active = ((TieredAutocrafterContainerMenu)this.getMenu()).canChangeName();
        this.setEditName(false);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (this.nameField != null && this.editName) {
            this.nameField.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.editName) {
            this.renderPlayerInventoryTitle(graphics);
            return;
        }
        super.renderLabels(graphics, mouseX, mouseY);
        Component title = TieredAutocrafterScreen.getChainingTitle((TieredAutocrafterContainerMenu)this.menu);
        graphics.drawString(this.font, title, this.getChainingTitleX(title), this.titleLabelY, 0x404040, false);
    }

    private boolean hasUpgrades() {
        return this.tier != CableTiers.CREATIVE;
    }

    private static int getTitleMaxWidth(TieredAutocrafterContainerMenu menu) {
        int chainingTitleWidth = Minecraft.getInstance().font.width((FormattedText)TieredAutocrafterScreen.getChainingTitle(menu));
        int editButtonWidth = TieredAutocrafterScreen.getEditButtonWidth();
        return 162 - chainingTitleWidth - editButtonWidth - 10;
    }

    private int getEditButtonX() {
        return this.leftPos + this.titleLabelX + this.titleMarquee.getEffectiveWidth(this.font) + 2;
    }

    private static int getEditButtonWidth() {
        return Minecraft.getInstance().font.width((FormattedText)EDIT) + 8;
    }

    private static Component getChainingTitle(TieredAutocrafterContainerMenu menu) {
        return menu.isPartOfChain() || menu.isHeadOfChain() ? CHAINED : NOT_CHAINED;
    }

    private Component getChainingTooltip() {
        if (!((TieredAutocrafterContainerMenu)this.getMenu()).isPartOfChain() && !((TieredAutocrafterContainerMenu)this.getMenu()).isHeadOfChain()) {
            return NOT_CHAINED_HELP;
        }
        return ((TieredAutocrafterContainerMenu)this.getMenu()).isHeadOfChain() ? CHAINED_HEAD_HELP : CHAINED_HELP;
    }

    private void tryAddLockModeSideButton() {
        if (((TieredAutocrafterContainerMenu)this.getMenu()).isPartOfChain()) {
            return;
        }
        this.lockModeSideButtonWidget = new LockModeSideButtonWidget((ClientProperty<LockMode>)((TieredAutocrafterContainerMenu)this.getMenu()).getProperty(AutocrafterPropertyTypes.LOCK_MODE));
        this.lockedChanged(((TieredAutocrafterContainerMenu)this.getMenu()).isLocked());
        this.addSideButton(this.lockModeSideButtonWidget);
    }

    private void setEditName(boolean editName) {
        this.editName = editName;
        if (this.nameField != null) {
            this.nameField.visible = editName;
            this.nameField.setFocused(editName);
            this.nameField.setCanLoseFocus(!editName);
            if (editName) {
                this.setFocused((GuiEventListener)this.nameField);
            } else {
                this.setFocused(null);
            }
        }
        if (this.editButton != null) {
            this.editButton.visible = !editName;
        }
    }

    private int getChainingTitleX(Component title) {
        return 169 - this.font.width((FormattedText)title);
    }

    public boolean charTyped(char unknown1, int unknown2) {
        return this.nameField != null && this.editName && this.nameField.charTyped(unknown1, unknown2) || super.charTyped(unknown1, unknown2);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.nameField != null && this.editName) {
            if (this.nameField.isFocused() && this.saveOrCancel(key)) {
                return true;
            }
            return this.nameField.keyPressed(key, scanCode, modifiers);
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private boolean saveOrCancel(int key) {
        if (key == 257 || key == 335) {
            ((TieredAutocrafterContainerMenu)this.getMenu()).changeName(Objects.requireNonNull(this.nameField).getValue());
            this.setEditName(false);
            return true;
        }
        if (key == 256) {
            this.setEditName(false);
            Objects.requireNonNull(this.nameField).setValue(this.titleMarquee.getText().getString());
            return true;
        }
        return false;
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        PatternSlot patternSlot;
        Slot slot = this.hoveredSlot;
        if (slot instanceof PatternSlot && !(patternSlot = (PatternSlot)slot).hasItem() && ((TieredAutocrafterContainerMenu)this.getMenu()).getCarried().isEmpty()) {
            graphics.renderTooltip(this.font, EMPTY_PATTERN_SLOT, x, y);
            return;
        }
        Component chainingTitle = TieredAutocrafterScreen.getChainingTitle((TieredAutocrafterContainerMenu)this.getMenu());
        int chainingTitleX = this.getChainingTitleX(chainingTitle);
        int n = this.font.width((FormattedText)chainingTitle);
        Objects.requireNonNull(this.font);
        if (this.isHovering(chainingTitleX, this.titleLabelY, n, 9, x, y)) {
            Component chainingTooltip = this.getChainingTooltip();
            Platform.INSTANCE.renderTooltip(graphics, List.of(HelpClientTooltipComponent.createAlwaysDisplayed((Component)chainingTooltip)), x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    protected ResourceLocation getTexture() {
        return AbstractAdvancedFilterScreen.getTexture(this.tier);
    }

    public void nameChanged(Component name) {
        this.titleMarquee.setText(name);
        if (this.nameField != null) {
            this.nameField.setValue(name.getString());
        }
        if (this.editButton != null) {
            this.editButton.setX(this.getEditButtonX());
        }
    }

    public void lockedChanged(boolean locked) {
        if (this.lockModeSideButtonWidget == null) {
            return;
        }
        if (locked) {
            this.lockModeSideButtonWidget.setWarning(CURRENTLY_LOCKED);
            return;
        }
        this.lockModeSideButtonWidget.setWarning(null);
    }
}

