/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.autocrafting.autocrafter;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.autocrafting.PatternInventory;
import com.refinedmods.refinedstorage.common.autocrafting.PatternSlot;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterContainerMenu;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.AutocrafterPropertyTypes;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.LockMode;
import com.ultramega.cabletiers.common.autocrafting.autocrafter.TieredAutocrafterBlockEntity;
import com.ultramega.cabletiers.common.packet.c2s.TieredAutocrafterNameChangePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterLockedUpdatePacket;
import com.ultramega.cabletiers.common.packet.s2c.TieredAutocrafterNameUpdatePacket;
import com.ultramega.cabletiers.common.registry.Menus;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TieredAutocrafterContainerMenu
extends AbstractBaseContainerMenu {
    private static final int PATTERN_SLOT_X = 8;
    private static final int PATTERN_SLOT_Y = 20;
    private final CableTiers tier;
    private final Player player;
    private final boolean partOfChain;
    private final boolean headOfChain;
    private boolean locked;
    private final RateLimiter nameRateLimiter = RateLimiter.create((double)0.5);
    @Nullable
    private TieredAutocrafterBlockEntity autocrafter;
    @Nullable
    private AutocrafterContainerMenu.Listener listener;
    private Component name;

    public TieredAutocrafterContainerMenu(int syncId, Inventory playerInventory, AutocrafterData data, CableTiers tier) {
        super(Menus.INSTANCE.getTieredAutocrafters(tier), syncId);
        this.tier = tier;
        this.player = playerInventory.player;
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.LOCK_MODE, (Object)LockMode.NEVER));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.PRIORITY, (Object)0));
        this.registerProperty((Property)new ClientProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, (Object)true));
        this.addSlots((FilteredContainer)new PatternInventory(tier.getFilterSlotsCount(), () -> ((Player)playerInventory.player).level()), new UpgradeContainer((UpgradeDestination)UpgradeDestinations.AUTOCRAFTER));
        this.name = Component.empty();
        this.partOfChain = data.partOfChain();
        this.headOfChain = data.headOfChain();
        this.locked = data.locked();
    }

    public TieredAutocrafterContainerMenu(int syncId, Inventory playerInventory, TieredAutocrafterBlockEntity autocrafter, CableTiers tier) {
        super(Menus.INSTANCE.getTieredAutocrafters(tier), syncId);
        this.tier = tier;
        this.autocrafter = autocrafter;
        this.player = playerInventory.player;
        this.name = autocrafter.getDisplayName();
        this.partOfChain = false;
        this.headOfChain = false;
        this.locked = autocrafter.isLocked();
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.LOCK_MODE, autocrafter::getLockMode, autocrafter::setLockMode));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.PRIORITY, autocrafter::getPriority, autocrafter::setPriority));
        this.registerProperty((Property)new ServerProperty(AutocrafterPropertyTypes.VISIBLE_TO_THE_AUTOCRAFTER_MANAGER, autocrafter::isVisibleToTheAutocrafterManager, autocrafter::setVisibleToTheAutocrafterManager));
        this.addSlots(autocrafter.getPatternContainer(), autocrafter.getUpgradeContainer());
    }

    boolean canChangeName() {
        return !this.partOfChain;
    }

    boolean isPartOfChain() {
        return this.partOfChain;
    }

    boolean isHeadOfChain() {
        return this.headOfChain;
    }

    boolean isLocked() {
        return this.locked;
    }

    void setListener(@Nullable AutocrafterContainerMenu.Listener listener) {
        this.listener = listener;
    }

    public void broadcastChanges() {
        boolean newLocked;
        super.broadcastChanges();
        if (this.autocrafter == null) {
            return;
        }
        if (this.nameRateLimiter.tryAcquire()) {
            this.detectNameChange();
        }
        if (this.locked != (newLocked = this.autocrafter.isLocked())) {
            this.locked = newLocked;
            Platform.INSTANCE.sendPacketToClient((ServerPlayer)this.player, (CustomPacketPayload)new TieredAutocrafterLockedUpdatePacket(this.locked));
        }
    }

    private void detectNameChange() {
        if (this.autocrafter == null) {
            return;
        }
        Component newName = this.autocrafter.getDisplayName();
        if (!newName.equals((Object)this.name)) {
            this.name = newName;
            Platform.INSTANCE.sendPacketToClient((ServerPlayer)this.player, (CustomPacketPayload)new TieredAutocrafterNameUpdatePacket(newName));
        }
    }

    private void addSlots(FilteredContainer patternContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < patternContainer.getContainerSize(); ++i) {
            this.addSlot(this.createPatternSlot(patternContainer, i, this.player.level()));
        }
        if (this.tier != CableTiers.CREATIVE) {
            for (i = 0; i < upgradeContainer.getContainerSize(); ++i) {
                this.addSlot((Slot)new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
            }
        }
        this.addPlayerInventory(this.player.getInventory(), 8, this.tier.getPlayerInventoryY());
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)upgradeContainer);
        this.transferManager.addBiTransfer((Container)this.player.getInventory(), (Container)patternContainer);
    }

    private Slot createPatternSlot(FilteredContainer patternContainer, int i, Level level) {
        int x = 8 + 18 * (i % 9);
        return new PatternSlot((Container)patternContainer, i, x, 20 + 18 * (i / 9), level);
    }

    public boolean containsPattern(ItemStack stack) {
        for (Slot slot : this.slots) {
            PatternSlot patternSlot;
            if (!(slot instanceof PatternSlot) || (patternSlot = (PatternSlot)slot).getItem() != stack) continue;
            return true;
        }
        return false;
    }

    public void changeName(String newName) {
        if (this.partOfChain) {
            return;
        }
        if (this.autocrafter != null) {
            this.autocrafter.setCustomName(newName);
            this.detectNameChange();
        } else {
            Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new TieredAutocrafterNameChangePacket(newName));
        }
    }

    public void nameChanged(Component newName) {
        if (this.listener != null) {
            this.listener.nameChanged(newName);
        }
    }

    public void lockedChanged(boolean newLocked) {
        this.locked = newLocked;
        if (this.listener != null) {
            this.listener.lockedChanged(newLocked);
        }
    }
}

