/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class DestructionRenderer {
    public static void render(RenderLevelStageEvent evt, Player player, ItemStack gadget) {
        Direction facing;
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        Level level = player.level();
        BlockPos anchor = GadgetNBT.getAnchorPos(gadget);
        Direction anchorSide = GadgetNBT.getAnchorSide(gadget);
        if (level.getBlockState(VectorHelper.getLookingAt(player, gadget).getBlockPos()) == Blocks.AIR.defaultBlockState() && anchor == null) {
            return;
        }
        BlockPos startBlock = anchor == GadgetNBT.nullPos ? lookingAt.getBlockPos() : anchor;
        Direction direction = facing = anchorSide == null ? lookingAt.getDirection() : anchorSide;
        if (level.getBlockState(startBlock) == ((RenderBlock)((Object)Registration.RenderBlock.get())).defaultBlockState()) {
            return;
        }
        Vec3 playerPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        PoseStack stack = evt.getPoseStack();
        stack.pushPose();
        stack.translate(-playerPos.x(), -playerPos.y(), -playerPos.z());
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(OurRenderTypes.MissingBlockOverlay);
        int[] counter = new int[]{BuildingUtils.getEnergyStored(gadget)};
        int energyCost = BuildingUtils.getEnergyCost(gadget);
        GadgetUtils.getDestructionArea(level, startBlock, facing, player, gadget).forEach(pos -> {
            if (counter[0] >= energyCost || player.isCreative()) {
                MyRenderMethods.renderBoxSolid(stack.last().pose(), builder, pos.pos, 1.0f, 0.0f, 0.0f, 0.35f);
            }
            counter[0] = counter[0] - energyCost;
        });
        stack.popPose();
        buffer.endBatch();
    }
}

