/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.breedablekillerrabbit.neoforge.events;

import com.natamus.breedablekillerrabbit_common_neoforge.events.RabbitEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class NeoForgeRabbitEvent {
    @SubscribeEvent
    public static void onBaby(BabyEntitySpawnEvent e) {
        AgeableMob child = e.getChild();
        Level level = child.level();
        if (level.isClientSide) {
            return;
        }
        Mob parentA = e.getParentA();
        Mob parentB = e.getParentB();
        if (!(parentA instanceof Animal) || !(parentB instanceof Animal)) {
            return;
        }
        RabbitEvent.onBaby((ServerLevel)level, (Animal)parentA, (Animal)parentB, e.getChild());
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract e) {
        Level world = e.getLevel();
        if (world.isClientSide) {
            return;
        }
        RabbitEvent.onEntityInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getTarget(), null);
    }

    @SubscribeEvent
    public static void onTarget(LivingIncomingDamageEvent e) {
        LivingEntity entity = e.getEntity();
        if (!RabbitEvent.onTarget(entity.level(), (Entity)entity, e.getSource(), e.getAmount())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void mobSpawn(EntityJoinLevelEvent e) {
        RabbitEvent.mobSpawn(e.getLevel(), e.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingDamageEvent.Post e) {
        LivingEntity entity = e.getEntity();
        RabbitEvent.onPlayerDamage(entity.level(), (Entity)entity, e.getSource(), e.getNewDamage());
    }
}

