/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.configurate.serialize;

import de.bluecolored.shadow.checkerframework.checker.nullness.qual.Nullable;
import de.bluecolored.shadow.configurate.serialize.AbstractListChildSerializer;
import de.bluecolored.shadow.configurate.serialize.SerializationException;
import de.bluecolored.shadow.configurate.util.CheckedConsumer;
import de.bluecolored.shadow.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

final class SetSerializer
extends AbstractListChildSerializer<Set<?>> {
    static boolean accepts(Type type) {
        Class<AbstractSet> erased = GenericTypeReflector.erase(type);
        return Set.class.isAssignableFrom(erased) && (erased.isAssignableFrom(EnumSet.class) || erased.isAssignableFrom(LinkedHashSet.class));
    }

    SetSerializer() {
    }

    @Override
    protected Type elementType(Type containerType) throws SerializationException {
        if (!(containerType instanceof ParameterizedType)) {
            throw new SerializationException("Raw types are not supported for collections");
        }
        return ((ParameterizedType)containerType).getActualTypeArguments()[0];
    }

    @Override
    protected Set<?> createNew(int length, Type elementType) {
        Class<?> erased = GenericTypeReflector.erase(elementType);
        if (erased.isEnum()) {
            return EnumSet.noneOf(erased.asSubclass(Enum.class));
        }
        return new LinkedHashSet(length);
    }

    @Override
    protected void forEachElement(Set<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    protected void deserializeSingle(int index, Set<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

