/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.chunk;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.BlockEntity;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.mca.chunk.MCAChunk;
import de.bluecolored.bluemap.core.world.mca.data.LenientBlockEntityArrayDeserializer;
import de.bluecolored.bluenbt.NBTDeserializer;
import de.bluecolored.bluenbt.NBTName;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class Chunk_1_13
extends MCAChunk {
    private static final Key STATUS_EMPTY = new Key("minecraft", "empty");
    private static final Key STATUS_FULL = new Key("minecraft", "full");
    private static final Key STATUS_FULLCHUNK = new Key("minecraft", "fullchunk");
    private static final Key STATUS_POSTPROCESSED = new Key("minecraft", "postprocessed");
    private final boolean generated;
    private final boolean hasLightData;
    private final long inhabitedTime;
    private final int skyLight;
    private final boolean hasWorldSurfaceHeights;
    private final long[] worldSurfaceHeights;
    private final boolean hasOceanFloorHeights;
    private final long[] oceanFloorHeights;
    private final Section[] sections;
    private final int sectionMin;
    private final int sectionMax;
    final int[] biomes;
    private final Map<Long, BlockEntity> blockEntities;

    public Chunk_1_13(MCAWorld world, Data data) {
        super(world, data);
        Level level = data.level;
        this.generated = !STATUS_EMPTY.equals(level.status);
        this.hasLightData = STATUS_FULL.equals(level.status) || STATUS_FULLCHUNK.equals(level.status) || STATUS_POSTPROCESSED.equals(level.status);
        this.inhabitedTime = level.inhabitedTime;
        DimensionType dimensionType = this.getWorld().getDimensionType();
        this.skyLight = dimensionType.hasSkylight() ? 15 : 0;
        this.worldSurfaceHeights = level.heightmaps.worldSurface;
        this.oceanFloorHeights = level.heightmaps.oceanFloor;
        this.hasWorldSurfaceHeights = this.worldSurfaceHeights.length >= 36;
        this.hasOceanFloorHeights = this.oceanFloorHeights.length >= 36;
        this.biomes = level.biomes;
        SectionData[] sectionsData = level.sections;
        if (sectionsData != null && sectionsData.length > 0) {
            int min2 = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (SectionData sectionData : sectionsData) {
                int y = sectionData.getY();
                if (min2 > y) {
                    min2 = y;
                }
                if (max >= y) continue;
                max = y;
            }
            this.sections = new Section[1 + max - min2];
            for (SectionData sectionData : sectionsData) {
                Section section = new Section(sectionData);
                int y = section.getSectionY();
                if (min2 > y) {
                    min2 = y;
                }
                if (max < y) {
                    max = y;
                }
                this.sections[section.sectionY - min2] = section;
            }
            this.sectionMin = min2;
            this.sectionMax = max;
        } else {
            this.sections = new Section[0];
            this.sectionMin = 0;
            this.sectionMax = 0;
        }
        this.blockEntities = new HashMap<Long, BlockEntity>(level.blockEntities.length);
        for (int i = 0; i < level.blockEntities.length; ++i) {
            BlockEntity be = level.blockEntities[i];
            if (be == null) continue;
            long hash = (long)be.getY() << 8 | (long)((be.getX() & 0xF) << 4) | (long)(be.getZ() & 0xF);
            this.blockEntities.put(hash, be);
        }
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public boolean hasLightData() {
        return this.hasLightData;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        Section section = this.getSection(y >> 4);
        if (section == null) {
            return BlockState.AIR;
        }
        return section.getBlockState(x, y, z);
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        if (this.biomes.length < 256) {
            return Biome.DEFAULT;
        }
        int biomeIntIndex = (z & 0xF) << 4 | x & 0xF;
        Biome biome = this.getWorld().getDataPack().getBiome(this.biomes[biomeIntIndex]);
        return biome != null ? biome : Biome.DEFAULT;
    }

    @Override
    public LightData getLightData(int x, int y, int z, LightData target) {
        if (!this.hasLightData) {
            return target.set(this.skyLight, 0);
        }
        int sectionY = y >> 4;
        Section section = this.getSection(sectionY);
        if (section == null) {
            return sectionY < this.sectionMin ? target.set(0, 0) : target.set(this.skyLight, 0);
        }
        return section.getLightData(x, y, z, target);
    }

    @Override
    public int getMinY(int x, int z) {
        return this.sectionMin * 16;
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.sectionMax * 16 + 15;
    }

    @Override
    public boolean hasWorldSurfaceHeights() {
        return this.hasWorldSurfaceHeights;
    }

    @Override
    public int getWorldSurfaceY(int x, int z) {
        return (int)MCAUtil.getValueFromLongStream(this.worldSurfaceHeights, (z & 0xF) << 4 | x & 0xF, 9);
    }

    @Override
    public boolean hasOceanFloorHeights() {
        return this.hasOceanFloorHeights;
    }

    @Override
    public int getOceanFloorY(int x, int z) {
        return (int)MCAUtil.getValueFromLongStream(this.oceanFloorHeights, (z & 0xF) << 4 | x & 0xF, 9);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(int x, int y, int z) {
        return this.blockEntities.get((long)y << 8 | (long)((x & 0xF) << 4) | (long)(z & 0xF));
    }

    @Override
    public void iterateBlockEntities(Consumer<BlockEntity> consumer) {
        this.blockEntities.values().forEach(consumer);
    }

    @Nullable
    private Section getSection(int y) {
        if ((y -= this.sectionMin) < 0 || y >= this.sections.length) {
            return null;
        }
        return this.sections[y];
    }

    public static class Data
    extends MCAChunk.Data {
        @NBTName(value={"Level"})
        private Level level = new Level();

        public Level getLevel() {
            return this.level;
        }
    }

    public static class Level {
        @NBTName(value={"Status"})
        private Key status = STATUS_EMPTY;
        @NBTName(value={"InhabitedTime"})
        private long inhabitedTime = 0L;
        @NBTName(value={"Heightmaps"})
        private HeightmapsData heightmaps = new HeightmapsData();
        @NBTName(value={"Sections"})
        private SectionData @Nullable [] sections = null;
        @NBTName(value={"Biomes"})
        private int[] biomes = MCAChunk.EMPTY_INT_ARRAY;
        @NBTName(value={"TileEntities"})
        @NBTDeserializer(value=LenientBlockEntityArrayDeserializer.class)
        @Nullable
        private BlockEntity[] blockEntities = MCAChunk.EMPTY_BLOCK_ENTITIES_ARRAY;

        public Key getStatus() {
            return this.status;
        }

        public long getInhabitedTime() {
            return this.inhabitedTime;
        }

        public HeightmapsData getHeightmaps() {
            return this.heightmaps;
        }

        public SectionData @Nullable [] getSections() {
            return this.sections;
        }

        public int[] getBiomes() {
            return this.biomes;
        }

        @Nullable
        public BlockEntity[] getBlockEntities() {
            return this.blockEntities;
        }
    }

    public static class HeightmapsData {
        @NBTName(value={"WORLD_SURFACE"})
        private long[] worldSurface = MCAChunk.EMPTY_LONG_ARRAY;
        @NBTName(value={"OCEAN_FLOOR"})
        private long[] oceanFloor = MCAChunk.EMPTY_LONG_ARRAY;

        public long[] getWorldSurface() {
            return this.worldSurface;
        }

        public long[] getOceanFloor() {
            return this.oceanFloor;
        }
    }

    public static class SectionData {
        @NBTName(value={"Y"})
        private int y = 0;
        @NBTName(value={"BlockLight"})
        private byte[] blockLight = MCAChunk.EMPTY_BYTE_ARRAY;
        @NBTName(value={"SkyLight"})
        private byte[] skyLight = MCAChunk.EMPTY_BYTE_ARRAY;
        @NBTName(value={"Palette"})
        private BlockState[] palette = MCAChunk.EMPTY_BLOCKSTATE_ARRAY;
        @NBTName(value={"BlockStates"})
        private long[] blockStates = MCAChunk.EMPTY_LONG_ARRAY;

        public int getY() {
            return this.y;
        }

        public byte[] getBlockLight() {
            return this.blockLight;
        }

        public byte[] getSkyLight() {
            return this.skyLight;
        }

        public BlockState[] getPalette() {
            return this.palette;
        }

        public long[] getBlockStates() {
            return this.blockStates;
        }
    }

    protected static class Section {
        private final int sectionY;
        private final BlockState[] blockPalette;
        private final long[] blocks;
        private final byte[] blockLight;
        private final byte[] skyLight;
        private final int bitsPerBlock;

        public Section(SectionData sectionData) {
            this.sectionY = sectionData.y;
            this.blockPalette = sectionData.palette;
            this.blocks = sectionData.blockStates;
            this.blockLight = sectionData.getBlockLight();
            this.skyLight = sectionData.getSkyLight();
            this.bitsPerBlock = this.blocks.length >> 6;
        }

        public BlockState getBlockState(int x, int y, int z) {
            if (this.blockPalette.length == 1) {
                return this.blockPalette[0];
            }
            if (this.blockPalette.length == 0) {
                return BlockState.AIR;
            }
            int id = (int)MCAUtil.getValueFromLongStream(this.blocks, (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF, this.bitsPerBlock);
            if (id >= this.blockPalette.length) {
                Logger.global.noFloodWarning("palette-warning", "Got block-palette id " + id + " but palette has size of " + this.blockPalette.length + "! (Future occasions of this error will not be logged)");
                return BlockState.MISSING;
            }
            return this.blockPalette[id];
        }

        public LightData getLightData(int x, int y, int z, LightData target) {
            if (this.blockLight.length == 0 && this.skyLight.length == 0) {
                return target.set(0, 0);
            }
            int blockByteIndex = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            int blockHalfByteIndex = blockByteIndex >> 1;
            boolean largeHalf = (blockByteIndex & 1) != 0;
            return target.set(this.skyLight.length > blockHalfByteIndex ? MCAUtil.getByteHalf(this.skyLight[blockHalfByteIndex], largeHalf) : 0, this.blockLight.length > blockHalfByteIndex ? MCAUtil.getByteHalf(this.blockLight[blockHalfByteIndex], largeHalf) : 0);
        }

        public int getSectionY() {
            return this.sectionY;
        }
    }
}

