/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.blockentity;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.bluemap.core.world.BlockEntity;
import de.bluecolored.bluemap.core.world.mca.blockentity.BannerBlockEntity;
import de.bluecolored.bluemap.core.world.mca.blockentity.SignBlockEntity;
import de.bluecolored.bluemap.core.world.mca.blockentity.SkullBlockEntity;

public interface BlockEntityType
extends Keyed {
    public static final BlockEntityType SIGN = new Impl(Key.minecraft("sign"), SignBlockEntity.class);
    public static final BlockEntityType HANGING_SIGN = new Impl(Key.minecraft("hanging_sign"), SignBlockEntity.class);
    public static final BlockEntityType SKULL = new Impl(Key.minecraft("skull"), SkullBlockEntity.class);
    public static final BlockEntityType BANNER = new Impl(Key.minecraft("banner"), BannerBlockEntity.class);
    public static final Registry<BlockEntityType> REGISTRY = new Registry((Keyed[])new BlockEntityType[]{SIGN, HANGING_SIGN, SKULL, BANNER});

    public Class<? extends BlockEntity> getBlockEntityClass();

    public static class Impl
    implements BlockEntityType {
        private final Key key;
        private final Class<? extends BlockEntity> blockEntityClass;

        public Impl(Key key, Class<? extends BlockEntity> blockEntityClass) {
            this.key = key;
            this.blockEntityClass = blockEntityClass;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public Class<? extends BlockEntity> getBlockEntityClass() {
            return this.blockEntityClass;
        }
    }
}

