/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block;

import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.BlockEntity;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.block.BlockAccess;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ExtendedBlock
implements BlockAccess {
    private int x;
    private int y;
    private int z;
    private BlockAccess blockAccess;
    private ResourcePack resourcePack;
    private RenderSettings renderSettings;
    private DimensionType dimensionType;
    @Nullable
    private BlockProperties properties;
    private boolean insideRenderBoundsCalculated;
    private boolean insideRenderBounds;
    private boolean isCaveCalculated;
    private boolean isCave;

    public ExtendedBlock(BlockAccess blockAccess, ResourcePack resourcePack, RenderSettings renderSettings, DimensionType dimensionType) {
        this.blockAccess = Objects.requireNonNull(blockAccess);
        this.resourcePack = Objects.requireNonNull(resourcePack);
        this.renderSettings = Objects.requireNonNull(renderSettings);
        this.dimensionType = Objects.requireNonNull(dimensionType);
    }

    @Override
    public void set(int x, int y, int z) {
        if (this.y == y && this.x == x && this.z == z) {
            return;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockAccess.set(x, y, z);
        this.properties = null;
        this.insideRenderBoundsCalculated = false;
        this.isCaveCalculated = false;
    }

    @Override
    public ExtendedBlock copy() {
        return new ExtendedBlock(this.blockAccess.copy(), this.resourcePack, this.renderSettings, this.dimensionType);
    }

    protected void copyFrom(ExtendedBlock extendedBlock) {
        this.x = extendedBlock.x;
        this.y = extendedBlock.y;
        this.z = extendedBlock.z;
        this.blockAccess = extendedBlock.blockAccess;
        this.resourcePack = extendedBlock.resourcePack;
        this.renderSettings = extendedBlock.renderSettings;
        this.dimensionType = extendedBlock.dimensionType;
        this.properties = extendedBlock.properties;
        this.insideRenderBoundsCalculated = extendedBlock.insideRenderBoundsCalculated;
        this.insideRenderBounds = extendedBlock.insideRenderBounds;
        this.isCaveCalculated = extendedBlock.isCaveCalculated;
        this.isCave = extendedBlock.isCave;
    }

    @Override
    public BlockState getBlockState() {
        if (this.renderSettings.isRenderEdges() && !this.isInsideRenderBounds()) {
            return BlockState.AIR;
        }
        return this.blockAccess.getBlockState();
    }

    @Override
    public LightData getLightData() {
        LightData ld = this.blockAccess.getLightData();
        if (this.renderSettings.isRenderEdges() && !this.isInsideRenderBounds()) {
            ld.set(this.dimensionType.hasSkylight() ? 16 : 0, ld.getBlockLight());
        }
        return ld;
    }

    @Override
    public Biome getBiome() {
        return this.blockAccess.getBiome();
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity() {
        return this.blockAccess.getBlockEntity();
    }

    @Override
    public boolean hasOceanFloorY() {
        return this.blockAccess.hasOceanFloorY();
    }

    @Override
    public int getOceanFloorY() {
        return this.blockAccess.getOceanFloorY();
    }

    public BlockProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.resourcePack.getBlockProperties(this.getBlockState());
        }
        return this.properties;
    }

    public boolean isInsideRenderBounds() {
        if (!this.insideRenderBoundsCalculated) {
            this.insideRenderBounds = this.renderSettings.isInsideRenderBoundaries(this.getX(), this.getY(), this.getZ());
            this.insideRenderBoundsCalculated = true;
        }
        return this.insideRenderBounds;
    }

    public boolean isRemoveIfCave() {
        if (!this.isCaveCalculated) {
            this.isCave = this.getY() < this.renderSettings.getRemoveCavesBelowY() && (!this.hasOceanFloorY() || this.getY() < this.getOceanFloorY() + this.renderSettings.getCaveDetectionOceanFloor());
            this.isCaveCalculated = true;
        }
        return this.isCave;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public ResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public RenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }
}

