/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.datapack;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.Pack;
import de.bluecolored.bluemap.core.resources.pack.datapack.biome.DatapackBiome;
import de.bluecolored.bluemap.core.resources.pack.datapack.dimension.DimensionTypeData;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.mca.chunk.LegacyBiomes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DataPack
extends Pack {
    public static final Key DIMENSION_OVERWORLD = new Key("minecraft", "overworld");
    public static final Key DIMENSION_THE_NETHER = new Key("minecraft", "the_nether");
    public static final Key DIMENSION_THE_END = new Key("minecraft", "the_end");
    public static final Key DIMENSION_TYPE_OVERWORLD = new Key("minecraft", "overworld");
    public static final Key DIMENSION_TYPE_OVERWORLD_CAVES = new Key("minecraft", "overworld_caves");
    public static final Key DIMENSION_TYPE_THE_NETHER = new Key("minecraft", "the_nether");
    public static final Key DIMENSION_TYPE_THE_END = new Key("minecraft", "the_end");
    private final Map<Key, DimensionType> dimensionTypes = new HashMap<Key, DimensionType>();
    private final Map<Key, Biome> biomes = new HashMap<Key, Biome>();
    private LegacyBiomes legacyBiomes;

    public DataPack(int packVersion) {
        super(packVersion);
    }

    @Override
    public void loadResources(Iterable<Path> roots) throws IOException, InterruptedException {
        Logger.global.logDebug("Loading datapack...");
        for (Path root : roots) {
            Logger.global.logDebug("Loading datapack from: " + String.valueOf(root) + " ...");
            this.loadResources(root);
        }
        Logger.global.logDebug("Baking datapack...");
        this.bake();
        Logger.global.logDebug("Datapack loaded.");
    }

    private void loadResources(Path root) throws InterruptedException, IOException {
        this.loadResourcePath(root, this::loadPath);
    }

    private void loadPath(Path root) {
        DataPack.list(root.resolve("data")).map(path -> path.resolve("dimension_type")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(x$0 -> DataPack.walk(x$0)).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, 1, 3, key -> {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                DimensionType dimensionType = (DimensionType)ResourcesGson.INSTANCE.fromJson((Reader)reader, DimensionTypeData.class);
                return dimensionType;
            }
        }, this.dimensionTypes));
        DataPack.list(root.resolve("data")).map(path -> path.resolve("worldgen").resolve("biome")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(x$0 -> DataPack.walk(x$0)).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, 1, 4, key -> {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                DatapackBiome datapackBiome = new DatapackBiome(key, (DatapackBiome.Data)ResourcesGson.INSTANCE.fromJson((Reader)reader, DatapackBiome.Data.class));
                return datapackBiome;
            }
        }, this.biomes));
    }

    public void bake() {
        this.dimensionTypes.putIfAbsent(DIMENSION_TYPE_OVERWORLD, DimensionType.OVERWORLD);
        this.dimensionTypes.putIfAbsent(DIMENSION_TYPE_OVERWORLD_CAVES, DimensionType.OVERWORLD_CAVES);
        this.dimensionTypes.putIfAbsent(DIMENSION_TYPE_THE_NETHER, DimensionType.NETHER);
        this.dimensionTypes.putIfAbsent(DIMENSION_TYPE_THE_END, DimensionType.END);
        this.legacyBiomes = new LegacyBiomes(this);
    }

    @Nullable
    public DimensionType getDimensionType(Key key) {
        return this.dimensionTypes.get(key);
    }

    @Nullable
    public Biome getBiome(Key key) {
        return this.biomes.get(key);
    }

    @Nullable
    public Biome getBiome(int legacyId) {
        return this.legacyBiomes.forId(legacyId);
    }
}

