/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class FileRequestHandler
implements HttpRequestHandler {
    @NonNull
    private Path webRoot;

    public FileRequestHandler(Path webRoot) {
        this.webRoot = webRoot.normalize();
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        if (!request.getMethod().equalsIgnoreCase("GET")) {
            return new HttpResponse(HttpStatusCode.BAD_REQUEST);
        }
        try {
            return this.generateResponse(request);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to serve file", e);
            return new HttpResponse(HttpStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    private HttpResponse generateResponse(HttpRequest request) throws IOException {
        Path filePath;
        String path = request.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            filePath = this.webRoot.resolve(path);
        }
        catch (InvalidPathException e) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        if (!filePath.normalize().startsWith(this.webRoot)) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        if (Files.isDirectory(filePath, new LinkOption[0]) && !request.getPath().endsWith("/")) {
            HttpResponse response = new HttpResponse(HttpStatusCode.SEE_OTHER);
            response.addHeader("Location", "/" + path + "/" + (String)(request.getGETParamString().isEmpty() ? "" : "?" + request.getGETParamString()));
            return response;
        }
        if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
            filePath = filePath.resolve("index.html");
        }
        if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
        if (filePath.getFileName().toString().endsWith(".php")) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        if (!filePath.normalize().startsWith(this.webRoot) || Files.isDirectory(filePath, new LinkOption[0])) {
            return new HttpResponse(HttpStatusCode.FORBIDDEN);
        }
        long lastModified = Files.getLastModifiedTime(filePath, new LinkOption[0]).to(TimeUnit.MILLISECONDS);
        HttpHeader modHeader = request.getHeader("If-Modified-Since");
        if (modHeader != null) {
            try {
                long since = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(modHeader.getValue())).toEpochMilli();
                if (since + 1000L >= lastModified) {
                    return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
                }
            }
            catch (DateTimeParseException since) {
                // empty catch block
            }
        }
        String eTag = Long.toHexString(Files.size(filePath)) + Integer.toHexString(filePath.hashCode()) + Long.toHexString(lastModified);
        HttpHeader etagHeader = request.getHeader("If-None-Match");
        if (etagHeader != null && etagHeader.getValue().equals(eTag)) {
            return new HttpResponse(HttpStatusCode.NOT_MODIFIED);
        }
        HttpResponse response = new HttpResponse(HttpStatusCode.OK);
        response.addHeader("ETag", eTag);
        if (lastModified > 0L) {
            response.addHeader("Last-Modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(Instant.ofEpochMilli(lastModified).atOffset(ZoneOffset.UTC)));
        }
        response.addHeader("Cache-Control", "public");
        response.addHeader("Cache-Control", "max-age=" + TimeUnit.DAYS.toSeconds(1L));
        String filetype = filePath.getFileName().toString();
        int pointIndex = filetype.lastIndexOf(46);
        if (pointIndex >= 0) {
            filetype = filetype.substring(pointIndex + 1);
        }
        String contentType = FileRequestHandler.toContentType(filetype);
        response.addHeader("Content-Type", contentType);
        try {
            response.setData(Files.newInputStream(filePath, new OpenOption[0]));
            return response;
        }
        catch (FileNotFoundException e) {
            return new HttpResponse(HttpStatusCode.NOT_FOUND);
        }
    }

    private static String toContentType(String fileEnding) {
        return switch (fileEnding) {
            case "json" -> "application/json";
            case "png" -> "image/png";
            case "jpg", "jpeg", "jpe" -> "image/jpeg";
            case "svg" -> "image/svg+xml";
            case "css" -> "text/css";
            case "js" -> "text/javascript";
            case "html", "htm", "shtml" -> "text/html";
            case "xml" -> "text/xml";
            default -> "text/plain";
        };
    }

    @NonNull
    public Path getWebRoot() {
        return this.webRoot;
    }

    public void setWebRoot(@NonNull Path webRoot) {
        if (webRoot == null) {
            throw new NullPointerException("webRoot is marked non-null but is null");
        }
        this.webRoot = webRoot;
    }
}

