/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class CachedRateLimitDataSupplier
implements Supplier<String> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Supplier<String> delegate;
    private final long rateLimitMillis;
    private long updateTime = -1L;
    private String data = null;

    public CachedRateLimitDataSupplier(Supplier<String> delegate, long rateLimitMillis) {
        this.delegate = delegate;
        this.rateLimitMillis = rateLimitMillis;
    }

    @Override
    public String get() {
        this.update();
        return this.data;
    }

    protected void update() {
        if (this.lock.tryLock()) {
            try {
                long now = System.currentTimeMillis();
                if (this.data != null && now < this.updateTime + this.rateLimitMillis) {
                    return;
                }
                this.data = this.delegate.get();
                this.updateTime = now;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

