/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.util.WatchService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class MapUpdateService
extends Thread {
    private final BmMap map;
    private final RenderManager renderManager;
    private final WatchService<Vector2i> watchService;
    private volatile boolean closed;
    private Timer delayTimer;
    private final Map<Vector2i, TimerTask> scheduledUpdates;

    public MapUpdateService(RenderManager renderManager, BmMap map) throws IOException {
        this.renderManager = renderManager;
        this.map = map;
        this.closed = false;
        this.scheduledUpdates = new HashMap<Vector2i, TimerTask>();
        this.watchService = map.getWorld().createRegionWatchService();
    }

    @Override
    public void run() {
        if (this.delayTimer == null) {
            this.delayTimer = new Timer("BlueMap-RegionFileWatchService-DelayTimer", true);
        }
        Logger.global.logDebug("Started watching map '" + this.map.getId() + "' for updates...");
        try {
            while (!this.closed) {
                this.watchService.take().forEach(this::updateRegion);
            }
        }
        catch (WatchService.ClosedException closedException) {
        }
        catch (IOException e) {
            Logger.global.logError("Exception trying to watch map '" + this.map.getId() + "' for updates.", e);
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
        finally {
            Logger.global.logDebug("Stopped watching map '" + this.map.getId() + "' for updates.");
            if (!this.closed) {
                Logger.global.logWarning("Region-file watch-service for map '" + this.map.getId() + "' stopped unexpectedly! (This map might not update automatically from now on)");
            }
        }
    }

    private synchronized void updateRegion(final Vector2i regionPos) {
        if (this.closed) {
            return;
        }
        TimerTask task = this.scheduledUpdates.remove(regionPos);
        if (task != null) {
            task.cancel();
        }
        task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MapUpdateService mapUpdateService = MapUpdateService.this;
                synchronized (mapUpdateService) {
                    WorldRegionRenderTask task = new WorldRegionRenderTask(MapUpdateService.this.map, regionPos);
                    MapUpdateService.this.scheduledUpdates.remove(regionPos);
                    MapUpdateService.this.renderManager.scheduleRenderTask(task);
                    Logger.global.logDebug("Scheduled update for region-file: " + String.valueOf(regionPos) + " (Map: " + MapUpdateService.this.map.getId() + ")");
                }
            }
        };
        this.scheduledUpdates.put(regionPos, task);
        this.delayTimer.schedule(task, 5000L);
    }

    public synchronized void close() {
        this.closed = true;
        this.interrupt();
        if (this.delayTimer != null) {
            this.delayTimer.cancel();
        }
        try {
            this.watchService.close();
        }
        catch (Exception ex) {
            Logger.global.logError("Exception while trying to close WatchService!", ex);
        }
    }
}

