/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.bluecolored.bluecommands.ParseFailure;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluecommands.brigadier.CommandExecutionHandler;
import de.bluecolored.bluemap.common.commands.CommandExecutor;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import java.util.Comparator;

public class BrigadierExecutionHandler
extends CommandExecutor
implements CommandExecutionHandler<CommandSource, Object> {
    private static final Message DEFAULT_FAILURE_MESSAGE = () -> "Unknown or incomplete command!";

    public BrigadierExecutionHandler(Plugin plugin) {
        super(plugin);
    }

    @Override
    public int handle(ParseResult<CommandSource, Object> parseResult) throws CommandSyntaxException {
        CommandExecutor.ExecutionResult executionResult = this.execute(parseResult);
        if (executionResult.parseFailure()) {
            return this.parseFailure(parseResult);
        }
        return executionResult.resultCode();
    }

    private int parseFailure(ParseResult<CommandSource, Object> result) throws CommandSyntaxException {
        ParseFailure failure = result.getFailures().stream().max(Comparator.comparing(ParseFailure::getPosition)).orElseThrow(() -> new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(DEFAULT_FAILURE_MESSAGE), DEFAULT_FAILURE_MESSAGE));
        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType(failure::getReason), failure::getReason, result.getInput(), failure.getPosition());
    }
}

