/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.api;

import de.bluecolored.bluemap.api.WebApp;
import de.bluecolored.bluemap.common.BlueMapService;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class WebAppImpl
implements WebApp {
    private final BlueMapService blueMapService;
    @Nullable
    private final Plugin plugin;
    private final Timer timer = new Timer("BlueMap-WebbAppImpl-Timer", true);
    @Nullable
    private TimerTask scheduledWebAppSettingsUpdate;

    public WebAppImpl(BlueMapService blueMapService, @Nullable Plugin plugin) {
        this.blueMapService = blueMapService;
        this.plugin = plugin;
    }

    public WebAppImpl(Plugin plugin) {
        this.blueMapService = plugin.getBlueMap();
        this.plugin = plugin;
    }

    @Override
    public Path getWebRoot() {
        return this.blueMapService.getConfig().getWebappConfig().getWebroot();
    }

    @Override
    public void setPlayerVisibility(UUID player, boolean visible) {
        if (this.plugin == null) {
            return;
        }
        if (visible) {
            this.plugin.getPluginState().removeHiddenPlayer(player);
        } else {
            this.plugin.getPluginState().addHiddenPlayer(player);
        }
    }

    @Override
    public boolean getPlayerVisibility(UUID player) {
        if (this.plugin == null) {
            return false;
        }
        return !this.plugin.getPluginState().isPlayerHidden(player);
    }

    @Override
    public synchronized void registerScript(String url) {
        Logger.global.logDebug("Registering script from API: " + url);
        this.blueMapService.getWebFilesManager().getScripts().add(url);
        this.scheduleUpdateWebAppSettings();
    }

    @Override
    public synchronized void registerStyle(String url) {
        Logger.global.logDebug("Registering style from API: " + url);
        this.blueMapService.getWebFilesManager().getStyles().add(url);
        this.scheduleUpdateWebAppSettings();
    }

    private synchronized void scheduleUpdateWebAppSettings() {
        if (!this.blueMapService.getConfig().getWebappConfig().isEnabled()) {
            return;
        }
        if (this.scheduledWebAppSettingsUpdate != null) {
            return;
        }
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WebAppImpl webAppImpl = WebAppImpl.this;
                synchronized (webAppImpl) {
                    try {
                        if (WebAppImpl.this.blueMapService.getConfig().getWebappConfig().isEnabled()) {
                            WebAppImpl.this.blueMapService.getWebFilesManager().saveSettings();
                        }
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to update webapp settings", ex);
                    }
                    finally {
                        WebAppImpl.this.scheduledWebAppSettingsUpdate = null;
                    }
                }
            }
        }, 1000L);
    }

    @Override
    @Deprecated(forRemoval=true)
    public String createImage(BufferedImage image, String path) throws IOException {
        path = path.replaceAll("[^a-zA-Z0-9_.\\-/]", "_");
        Path webRoot = this.getWebRoot().toAbsolutePath();
        String separator = webRoot.getFileSystem().getSeparator();
        Path imageRootFolder = webRoot.resolve("data").resolve("images");
        Path imagePath = imageRootFolder.resolve(path.replace("/", separator) + ".png").toAbsolutePath();
        FileHelper.createDirectories(imagePath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(imagePath);
        Files.createFile(imagePath, new FileAttribute[0]);
        if (!ImageIO.write((RenderedImage)image, "png", imagePath.toFile())) {
            throw new IOException("The format 'png' is not supported!");
        }
        return webRoot.relativize(imagePath).toString().replace(separator, "/");
    }

    @Override
    @Deprecated(forRemoval=true)
    public Map<String, String> availableImages() throws IOException {
        Path webRoot = this.getWebRoot().toAbsolutePath();
        String separator = webRoot.getFileSystem().getSeparator();
        Path imageRootPath = webRoot.resolve("data").resolve("images").toAbsolutePath();
        HashMap<String, String> availableImagesMap = new HashMap<String, String>();
        if (Files.exists(imageRootPath, new LinkOption[0])) {
            try (Stream<Path> fileStream = Files.walk(imageRootPath, new FileVisitOption[0]);){
                fileStream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".png")).map(Path::toAbsolutePath).forEach(p -> {
                    try {
                        String key = imageRootPath.relativize((Path)p).toString();
                        key = key.substring(0, key.length() - 4).replace(separator, "/");
                        String value = webRoot.relativize((Path)p).toString().replace(separator, "/");
                        availableImagesMap.put(key, value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
            }
        }
        return availableImagesMap;
    }
}

