/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import de.bluecolored.bluecommands.ArgumentCommand;
import de.bluecolored.bluecommands.Command;
import de.bluecolored.bluecommands.LiteralCommand;
import de.bluecolored.bluecommands.brigadier.CommandCommand;
import de.bluecolored.bluecommands.brigadier.CommandExecutionHandler;
import de.bluecolored.bluecommands.brigadier.CommandSuggestionProvider;
import de.bluecolored.bluecommands.brigadier.DefaultExecutionHandler;
import de.bluecolored.bluecommands.parsers.ArgumentParser;
import de.bluecolored.bluecommands.parsers.NumberArgumentParser;
import de.bluecolored.bluecommands.parsers.SimpleArgumentParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class BrigadierBridge {
    private BrigadierBridge() {
    }

    public static <C, T> Collection<CommandNode<C>> createCommandNodes(Command<C, T> command) {
        return BrigadierBridge.createCommandNodes(command, new DefaultExecutionHandler());
    }

    public static <C, T> Collection<CommandNode<C>> createCommandNodes(Command<C, T> command, CommandExecutionHandler<C, T> executionHandler) {
        return BrigadierBridge.createCommandNodes(command, executionHandler, c -> c);
    }

    public static <C, D, T> Collection<CommandNode<D>> createCommandNodes(Command<C, T> command, CommandExecutionHandler<C, T> executionHandler, Function<D, C> contextConverter) {
        return BrigadierBridge.createCommandNodes(List.of(command), new CommandSuggestionProvider<D>(command, contextConverter), new CommandCommand<C, D, T>(command, executionHandler, contextConverter), contextConverter);
    }

    private static <C, D, T> Collection<CommandNode<D>> createCommandNodes(Collection<Command<C, T>> commands, SuggestionProvider<D> suggestionProvider, com.mojang.brigadier.Command<D> executor, Function<D, C> contextConverter) {
        HashSet<Command<C, T>> nodes = new HashSet<Command<C, T>>();
        for (Command<C, T> command : commands) {
            BrigadierBridge.collectNodes(command, nodes);
        }
        ArrayList<CommandNode<D>> commandNodes = new ArrayList<CommandNode<D>>(1);
        for (Command command : nodes) {
            if (!(command instanceof LiteralCommand)) continue;
            LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)((LiteralCommand)command).getLiteral());
            builder.requires(d -> node.isValid(contextConverter.apply(d)));
            if (command.getExecutable() != null) {
                builder.executes(executor);
            }
            BrigadierBridge.createCommandNodes(command.getSubCommands(), suggestionProvider, executor, contextConverter).forEach(arg_0 -> ((LiteralArgumentBuilder)builder).then(arg_0));
            commandNodes.add((CommandNode<D>)builder.build());
        }
        EnumMap enumMap = nodes.stream().filter(c -> c instanceof ArgumentCommand).map(c -> (ArgumentCommand)c).collect(Collectors.groupingBy(x$0 -> CommonNodeType.getFor(x$0), () -> new EnumMap(CommonNodeType.class), Collectors.toSet()));
        if (enumMap.containsKey((Object)CommonNodeType.WORD) && enumMap.containsKey((Object)CommonNodeType.STRING)) {
            ((Set)enumMap.get((Object)CommonNodeType.STRING)).addAll((Collection)enumMap.remove((Object)CommonNodeType.WORD));
        }
        if (enumMap.containsKey((Object)CommonNodeType.STRING) && enumMap.containsKey((Object)CommonNodeType.GREEDY)) {
            ((Set)enumMap.get((Object)CommonNodeType.GREEDY)).addAll((Collection)enumMap.remove((Object)CommonNodeType.STRING));
        }
        enumMap.forEach((type, arguments) -> {
            RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)BrigadierBridge.getCommonArgumentId(type, arguments), type.getArgumentType());
            if (type == CommonNodeType.GREEDY || type == CommonNodeType.STRING || type == CommonNodeType.WORD) {
                builder.suggests(suggestionProvider);
            }
            builder.requires(d -> {
                Object context = contextConverter.apply(d);
                return arguments.stream().anyMatch(arg -> arg.isValid(context));
            });
            if (arguments.stream().map(Command::getExecutable).anyMatch(Objects::nonNull)) {
                builder.executes(executor);
            }
            if (type != CommonNodeType.GREEDY) {
                Collection subCommands = arguments.stream().flatMap(c -> c.getSubCommands().stream()).collect(Collectors.toSet());
                BrigadierBridge.createCommandNodes(subCommands, suggestionProvider, executor, contextConverter).forEach(arg_0 -> ((RequiredArgumentBuilder)builder).then(arg_0));
            }
            commandNodes.add((CommandNode)builder.build());
        });
        return commandNodes;
    }

    private static <C, T> void collectNodes(Command<C, T> command, Set<Command<C, T>> nodes) {
        if (!(command instanceof LiteralCommand) && !(command instanceof ArgumentCommand)) {
            for (Command<C, T> subCommand : command.getSubCommands()) {
                BrigadierBridge.collectNodes(subCommand, nodes);
            }
            return;
        }
        nodes.add(command);
        if (command.isOptional()) {
            for (Command<C, T> subCommand : command.getSubCommands()) {
                BrigadierBridge.collectNodes(subCommand, nodes);
            }
        }
    }

    private static <C, T> String getCommonArgumentId(CommonNodeType type, Collection<ArgumentCommand<C, T>> arguments) {
        Object commonNodeName = arguments.size() <= 3 ? (type == CommonNodeType.GREEDY ? "..." : arguments.stream().map(ArgumentCommand::getArgumentId).distinct().sorted().collect(Collectors.joining("|"))) : "arg-" + UUID.randomUUID().toString().substring(0, 8);
        return commonNodeName;
    }

    private static enum CommonNodeType {
        INTEGER((ArgumentType<?>)LongArgumentType.longArg()),
        NUMBER((ArgumentType<?>)DoubleArgumentType.doubleArg()),
        WORD((ArgumentType<?>)StringArgumentType.word()),
        STRING((ArgumentType<?>)StringArgumentType.string()),
        GREEDY((ArgumentType<?>)StringArgumentType.greedyString());

        private final ArgumentType<?> argumentType;

        private CommonNodeType(ArgumentType<?> argumentType) {
            this.argumentType = argumentType;
        }

        public ArgumentType<?> getArgumentType() {
            return this.argumentType;
        }

        private static CommonNodeType getFor(ArgumentCommand<?, ?> argumentCommand) {
            ArgumentParser<?, ?> parser = argumentCommand.getArgumentParser();
            if (parser instanceof NumberArgumentParser) {
                Class numberType = ((NumberArgumentParser)parser).getType();
                if (numberType == Float.class || numberType == Double.class) {
                    return NUMBER;
                }
                return INTEGER;
            }
            if (parser instanceof SimpleArgumentParser) {
                SimpleArgumentParser sParser = (SimpleArgumentParser)parser;
                if (sParser.isGreedy()) {
                    return GREEDY;
                }
                if (sParser.isAllowQuoted()) {
                    return STRING;
                }
                return WORD;
            }
            return GREEDY;
        }
    }
}

