/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.TextureAtlasHolder;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtlasManager.class);
    public static final AtlasManager INSTANCE = new AtlasManager();
    private final Map<String, CustomGuiSpriteManager> modAtlases = new HashMap<String, CustomGuiSpriteManager>();

    private AtlasManager() {
    }

    public void addAtlas(Consumer<PreparableReloadListener> resourceRegistry, String modId) {
        this.modAtlases.computeIfAbsent(modId, id -> {
            CustomGuiSpriteManager spriteManager = new CustomGuiSpriteManager(this, Minecraft.getInstance().getTextureManager(), (String)id);
            resourceRegistry.accept((PreparableReloadListener)spriteManager);
            return spriteManager;
        });
    }

    public TextureAtlasSprite getSprite(ResourceLocation resLoc) {
        TextureAtlasSprite sprite;
        CustomGuiSpriteManager spriteManager = this.modAtlases.get(resLoc.getNamespace());
        if (spriteManager != null && (sprite = spriteManager.getSprite(resLoc)).contents().name() != MissingTextureAtlasSprite.getLocation()) {
            return sprite;
        }
        return Minecraft.getInstance().getGuiSprites().getSprite(resLoc);
    }

    public void dumpAtlases(Path dumpingFolder) {
        this.modAtlases.forEach((modId, spriteManager) -> {
            try {
                spriteManager.textureAtlas.dumpContents(spriteManager.textureAtlas.location(), Files.createDirectories(dumpingFolder.resolve((String)modId), new FileAttribute[0]));
            }
            catch (IOException e) {
                LOGGER.warn("Failed to dump atlas for mod id: " + modId, (Throwable)e);
            }
        });
    }

    public static GuiSpriteScaling getSpriteScaling(TextureAtlasSprite textureAtlasSprite) {
        return textureAtlasSprite.contents().metadata().getSection((MetadataSectionSerializer)GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
    }

    private class CustomGuiSpriteManager
    extends TextureAtlasHolder {
        private CustomGuiSpriteManager(AtlasManager atlasManager, TextureManager textureManager, String modId) {
            super(textureManager, ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/atlas/" + modId + "_gui.png")), ResourceLocation.fromNamespaceAndPath((String)modId, (String)(modId + "_gui")), GuiSpriteManager.METADATA_SECTIONS);
        }

        public TextureAtlasSprite getSprite(ResourceLocation resLoc) {
            return super.getSprite(resLoc);
        }
    }
}

