/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.util.init;

import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.util.init.GroupingDeferredHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class WoodTypeDeferredHolder<R, T extends R>
implements GroupingDeferredHolder<R, T> {
    private final Map<BibliocraftWoodType, DeferredHolder<R, T>> map = new LinkedHashMap<BibliocraftWoodType, DeferredHolder<R, T>>();

    public WoodTypeDeferredHolder(DeferredRegister<R> register, String suffix, Function<BibliocraftWoodType, ? extends T> creator) {
        for (BibliocraftWoodType type : BibliocraftApi.getWoodTypeRegistry().getAll()) {
            this.map.put(type, register.register(type.getRegistrationPrefix() + "_" + suffix, () -> creator.apply(type)));
        }
    }

    public DeferredHolder<R, T> holder(BibliocraftWoodType type) {
        return this.map.get(type);
    }

    public T get(BibliocraftWoodType type) {
        DeferredHolder<R, T> holder = this.holder(type);
        if (holder == null) {
            return null;
        }
        return (T)holder.get();
    }

    public ResourceLocation id(BibliocraftWoodType type) {
        DeferredHolder<R, T> holder = this.holder(type);
        if (holder == null) {
            return null;
        }
        return holder.getId();
    }

    public Map<BibliocraftWoodType, DeferredHolder<R, T>> map() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public Collection<DeferredHolder<R, T>> holders() {
        return this.map.values();
    }

    @Override
    public Collection<T> values() {
        return this.map.values().stream().map(DeferredHolder::get).toList();
    }

    @Override
    public Collection<ResourceLocation> ids() {
        return this.map.values().stream().map(DeferredHolder::getId).toList();
    }
}

