/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancylight;

import com.github.minecraftschurlimods.bibliocraft.content.fancylight.AbstractFancyLightBlock;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FancyLanternBlock
extends AbstractFancyLightBlock {
    private static final VoxelShape STANDING_SHAPE = ShapeUtil.combine(Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.0625, (double)0.75), Shapes.box((double)0.3125, (double)0.0625, (double)0.3125, (double)0.375, (double)0.625, (double)0.375), Shapes.box((double)0.625, (double)0.0625, (double)0.3125, (double)0.6875, (double)0.625, (double)0.375), Shapes.box((double)0.3125, (double)0.0625, (double)0.625, (double)0.375, (double)0.625, (double)0.6875), Shapes.box((double)0.625, (double)0.0625, (double)0.625, (double)0.6875, (double)0.625, (double)0.6875), Shapes.box((double)0.34375, (double)0.0625, (double)0.34375, (double)0.65625, (double)0.625, (double)0.65625), Shapes.box((double)0.25, (double)0.625, (double)0.25, (double)0.75, (double)0.6875, (double)0.75), Shapes.box((double)0.3125, (double)0.6875, (double)0.3125, (double)0.6875, (double)0.75, (double)0.6875), Shapes.box((double)0.375, (double)0.75, (double)0.375, (double)0.625, (double)0.8125, (double)0.625));
    private static final VoxelShape HANGING_SHAPE = ShapeUtil.combine(STANDING_SHAPE, Shapes.box((double)0.40625, (double)0.8125, (double)0.40625, (double)0.59375, (double)1.0, (double)0.59375));
    private static final VoxelShape NORTH_WALL_SHAPE = ShapeUtil.combine(STANDING_SHAPE, Shapes.box((double)0.4375, (double)0.65625, (double)0.9375, (double)0.5625, (double)0.90625, (double)1.0), Shapes.box((double)0.46875, (double)0.70625, (double)0.875, (double)0.53125, (double)0.83125, (double)0.9375), Shapes.box((double)0.46875, (double)0.8125, (double)0.46875, (double)0.53125, (double)0.925, (double)0.9375));
    private static final VoxelShape EAST_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.COUNTERCLOCKWISE_90);

    public FancyLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((AbstractFancyLightBlock.Type)((Object)state.getValue((Property)TYPE))) {
            default -> throw new MatchException(null, null);
            case AbstractFancyLightBlock.Type.STANDING -> STANDING_SHAPE;
            case AbstractFancyLightBlock.Type.HANGING -> HANGING_SHAPE;
            case AbstractFancyLightBlock.Type.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    default: {
                        yield NORTH_WALL_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_WALL_SHAPE;
                    }
                    case WEST: {
                        yield WEST_WALL_SHAPE;
                    }
                    case EAST: 
                }
                yield EAST_WALL_SHAPE;
            }
        };
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Vec3 offset = Vec3.atCenterOf((Vec3i)pos);
        if (random.nextFloat() < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
    }
}

