/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancylight;

import com.github.minecraftschurlimods.bibliocraft.content.fancylight.AbstractFancyLightBlock;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FancyLampBlock
extends AbstractFancyLightBlock {
    private static final VoxelShape NORTH_STANDING_SHAPE = ShapeUtil.combine(Shapes.box((double)0.3125, (double)0.0, (double)0.34375, (double)0.6875, (double)0.0625, (double)0.71875), Shapes.box((double)0.375, (double)0.0625, (double)0.40625, (double)0.625, (double)0.125, (double)0.65625), Shapes.box((double)0.4375, (double)0.125, (double)0.46875, (double)0.5625, (double)0.25, (double)0.59375), Shapes.box((double)0.46875, (double)0.25, (double)0.5, (double)0.53125, (double)0.89375, (double)0.75), Shapes.box((double)0.125, (double)0.71875, (double)0.0625, (double)0.875, (double)0.9375, (double)0.5), Shapes.box((double)0.125, (double)0.71875, (double)0.0, (double)0.875, (double)0.875, (double)0.0625), Shapes.box((double)0.125, (double)0.65625, (double)0.0, (double)0.875, (double)0.71875, (double)0.4375), Shapes.box((double)0.125, (double)0.59375, (double)0.0, (double)0.875, (double)0.65625, (double)0.21875));
    private static final VoxelShape EAST_STANDING_SHAPE = ShapeUtil.rotate(NORTH_STANDING_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_STANDING_SHAPE = ShapeUtil.rotate(NORTH_STANDING_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_STANDING_SHAPE = ShapeUtil.rotate(NORTH_STANDING_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape NORTH_HANGING_SHAPE = ShapeUtil.combine(Shapes.box((double)0.3125, (double)0.9375, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), Shapes.box((double)0.375, (double)0.875, (double)0.375, (double)0.625, (double)0.9375, (double)0.625), Shapes.box((double)0.4375, (double)0.75, (double)0.4375, (double)0.5625, (double)0.875, (double)0.5625), Shapes.box((double)0.46875, (double)0.28125, (double)0.46875, (double)0.53125, (double)0.75, (double)0.53125), Shapes.box((double)0.125, (double)0.1875, (double)0.0625, (double)0.875, (double)0.40625, (double)0.5), Shapes.box((double)0.125, (double)0.1875, (double)0.0, (double)0.875, (double)0.34375, (double)0.0625), Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.1875, (double)0.4375), Shapes.box((double)0.125, (double)0.0625, (double)0.0, (double)0.875, (double)0.125, (double)0.21875), Shapes.box((double)0.125, (double)0.1875, (double)0.5, (double)0.875, (double)0.40625, (double)0.9375), Shapes.box((double)0.125, (double)0.1875, (double)0.9375, (double)0.875, (double)0.34375, (double)1.0), Shapes.box((double)0.125, (double)0.125, (double)0.5625, (double)0.875, (double)0.1875, (double)1.0), Shapes.box((double)0.125, (double)0.0625, (double)0.78125, (double)0.875, (double)0.125, (double)1.0));
    private static final VoxelShape EAST_HANGING_SHAPE = ShapeUtil.rotate(NORTH_HANGING_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_HANGING_SHAPE = ShapeUtil.rotate(NORTH_HANGING_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_HANGING_SHAPE = ShapeUtil.rotate(NORTH_HANGING_SHAPE, Rotation.COUNTERCLOCKWISE_90);
    private static final VoxelShape NORTH_WALL_SHAPE = ShapeUtil.combine(Shapes.box((double)0.4375, (double)0.09375, (double)0.9375, (double)0.5625, (double)0.34375, (double)1.0), Shapes.box((double)0.46875, (double)0.14375, (double)0.875, (double)0.53125, (double)0.26875, (double)0.9375), Shapes.box((double)0.46875, (double)0.2375, (double)0.5, (double)0.53125, (double)0.3625, (double)0.9375), Shapes.box((double)0.125, (double)0.1875, (double)0.0625, (double)0.875, (double)0.40625, (double)0.5), Shapes.box((double)0.125, (double)0.1875, (double)0.0, (double)0.875, (double)0.34375, (double)0.0625), Shapes.box((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.1875, (double)0.4375), Shapes.box((double)0.125, (double)0.0625, (double)0.0, (double)0.875, (double)0.125, (double)0.21875));
    private static final VoxelShape EAST_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.CLOCKWISE_90);
    private static final VoxelShape SOUTH_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.CLOCKWISE_180);
    private static final VoxelShape WEST_WALL_SHAPE = ShapeUtil.rotate(NORTH_WALL_SHAPE, Rotation.COUNTERCLOCKWISE_90);

    public FancyLampBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        AbstractFancyLightBlock.Type type = (AbstractFancyLightBlock.Type)((Object)state.getValue((Property)TYPE));
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case AbstractFancyLightBlock.Type.STANDING -> {
                switch (facing) {
                    default: {
                        yield NORTH_STANDING_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_STANDING_SHAPE;
                    }
                    case WEST: {
                        yield WEST_STANDING_SHAPE;
                    }
                    case EAST: 
                }
                yield EAST_STANDING_SHAPE;
            }
            case AbstractFancyLightBlock.Type.HANGING -> {
                switch (facing) {
                    default: {
                        yield NORTH_HANGING_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_HANGING_SHAPE;
                    }
                    case WEST: {
                        yield WEST_HANGING_SHAPE;
                    }
                    case EAST: 
                }
                yield EAST_HANGING_SHAPE;
            }
            case AbstractFancyLightBlock.Type.WALL -> {
                switch (facing) {
                    default: {
                        yield NORTH_WALL_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_WALL_SHAPE;
                    }
                    case WEST: {
                        yield WEST_WALL_SHAPE;
                    }
                    case EAST: 
                }
                yield EAST_WALL_SHAPE;
            }
        };
    }
}

