/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.fancycrafter;

import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterSlot;
import com.github.minecraftschurlimods.bibliocraft.init.BCMenus;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FancyCrafterMenu
extends BCMenu<FancyCrafterBlockEntity> {
    public FancyCrafterMenu(int id, Inventory inventory, FancyCrafterBlockEntity blockEntity) {
        super(BCMenus.FANCY_CRAFTER.get(), id, inventory, blockEntity);
    }

    public FancyCrafterMenu(int id, Inventory inventory, FriendlyByteBuf data) {
        super(BCMenus.FANCY_CRAFTER.get(), id, inventory, data);
    }

    @Override
    protected void addSlots(Inventory inventory) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.addSlot(new FancyCrafterSlot((FancyCrafterBlockEntity)this.blockEntity, x + y * 3, 30 + x * 18, 17 + y * 18));
            }
        }
        this.addSlot(new ViewSlot(this.blockEntity, 9, 124, 35));
        for (int i = 0; i < 8; ++i) {
            this.addSlot(new Slot((Container)this.blockEntity, i + 10, 17 + i * 18, 78));
        }
        this.addInventorySlots(inventory, 8, 110);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        int slotCount = ((FancyCrafterBlockEntity)this.blockEntity).getContainerSize();
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (index < slotCount) {
            if (index == 9) {
                return stack;
            }
            if (!this.moveItemStackTo(slot.getItem(), slotCount, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 9) {
            if (!this.moveItemStackToEnabled(stack, 0, 9)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, 10, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, slotCount + 9, slotCount + 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < slotCount + 36) {
            if (!this.moveItemStackToEnabled(stack, 0, 9)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, 10, slotCount, false)) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(stack, slotCount, slotCount + 9, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return originalStack;
    }

    public void setSlotDisabled(int slot, boolean disabled) {
        if (slot > 8) {
            return;
        }
        ((FancyCrafterBlockEntity)this.blockEntity).setSlotDisabled(slot, disabled);
        this.broadcastChanges();
    }

    public boolean isSlotDisabled(int slot) {
        return ((FancyCrafterBlockEntity)this.blockEntity).isSlotDisabled(slot);
    }

    private boolean moveItemStackToEnabled(ItemStack stack, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (((FancyCrafterBlockEntity)this.blockEntity).isSlotDisabled(i) || this.moveItemStackTo(stack, i, i + 1, false)) continue;
            return false;
        }
        return true;
    }

    private static class ViewSlot
    extends Slot {
        public ViewSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player player) {
            return false;
        }
    }
}

