/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.discrack;

import com.github.minecraftschurlimods.bibliocraft.content.discrack.DiscRackBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCFacingInteractibleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DiscRackBlock
extends BCFacingInteractibleBlock {
    private static final VoxelShape Z_SHAPE = ShapeUtil.combine(Shapes.box((double)0.3125, (double)0.0, (double)0.1875, (double)0.6875, (double)0.0625, (double)0.8125), Shapes.box((double)0.375, (double)0.0625, (double)0.203125, (double)0.625, (double)0.25, (double)0.796875));
    private static final VoxelShape X_SHAPE = ShapeUtil.rotate(Z_SHAPE, Rotation.CLOCKWISE_90);

    public DiscRackBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_SHAPE : Z_SHAPE;
    }

    @Override
    public int lookingAtSlot(BlockState state, BlockHitResult hit) {
        Vec3 pos = hit.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)hit.getBlockPos())).scale(16.0);
        double value = switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> pos.z() - 3.5;
            case Direction.EAST -> pos.x() - 3.5;
            case Direction.NORTH -> 12.5 - pos.z();
            case Direction.WEST -> 12.5 - pos.x();
            default -> -1.0;
        };
        return value == -1.0 ? -1 : (int)value;
    }

    @Override
    protected boolean canAccessFromDirection(BlockState state, Direction direction) {
        return direction == Direction.UP || ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X && direction.getAxis() == Direction.Axis.Z || ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.Z && direction.getAxis() == Direction.Axis.X;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DiscRackBlockEntity(pos, state);
    }
}

