/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.dinnerplate;

import com.github.minecraftschurlimods.bibliocraft.content.dinnerplate.DinnerPlateBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.util.ShapeUtil;
import com.github.minecraftschurlimods.bibliocraft.util.content.BCEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DinnerPlateBlock
extends BCEntityBlock {
    public static final IntegerProperty PROGRESS = IntegerProperty.create((String)"progress", (int)0, (int)3);
    public static final VoxelShape SHAPE = ShapeUtil.combine(Shapes.box((double)0.25, (double)0.0, (double)0.3125, (double)0.75, (double)0.0625, (double)0.6875), Shapes.box((double)0.1875, (double)0.0, (double)0.375, (double)0.25, (double)0.0625, (double)0.625), Shapes.box((double)0.75, (double)0.0, (double)0.375, (double)0.8125, (double)0.0625, (double)0.625), Shapes.box((double)0.71875, (double)0.03125, (double)0.34375, (double)0.78125, (double)0.09375, (double)0.65625), Shapes.box((double)0.34375, (double)0.03125, (double)0.21875, (double)0.65625, (double)0.09375, (double)0.28125), Shapes.box((double)0.21875, (double)0.03125, (double)0.34375, (double)0.28125, (double)0.09375, (double)0.65625), Shapes.box((double)0.34375, (double)0.03125, (double)0.71875, (double)0.65625, (double)0.09375, (double)0.78125), Shapes.box((double)0.28125, (double)0.03125, (double)0.28125, (double)0.40625, (double)0.09375, (double)0.34375), Shapes.box((double)0.28125, (double)0.03125, (double)0.34375, (double)0.34375, (double)0.09375, (double)0.40625), Shapes.box((double)0.59375, (double)0.03125, (double)0.28125, (double)0.71875, (double)0.09375, (double)0.34375), Shapes.box((double)0.65625, (double)0.03125, (double)0.34375, (double)0.71875, (double)0.09375, (double)0.40625), Shapes.box((double)0.59375, (double)0.03125, (double)0.65625, (double)0.71875, (double)0.09375, (double)0.71875), Shapes.box((double)0.65625, (double)0.03125, (double)0.59375, (double)0.71875, (double)0.09375, (double)0.65625), Shapes.box((double)0.28125, (double)0.03125, (double)0.65625, (double)0.40625, (double)0.09375, (double)0.71875), Shapes.box((double)0.28125, (double)0.03125, (double)0.59375, (double)0.34375, (double)0.09375, (double)0.65625));

    public DinnerPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DinnerPlateBlockEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState newState = state;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DinnerPlateBlockEntity)) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        DinnerPlateBlockEntity plate = (DinnerPlateBlockEntity)blockEntity;
        ItemStack slotStack = plate.getItem(0);
        if (stack.getFoodProperties((LivingEntity)player) != null) {
            if (slotStack.isEmpty()) {
                ItemStack foodStack = stack.copy();
                foodStack.setCount(1);
                plate.setItem(0, foodStack);
                stack.shrink(1);
                newState = (BlockState)newState.setValue((Property)PROGRESS, (Comparable)Integer.valueOf(0));
            } else {
                newState = (BlockState)newState.setValue((Property)PROGRESS, (Comparable)Integer.valueOf((Integer)newState.getValue((Property)PROGRESS) + 1));
                this.triggerItemUseEffects(player, slotStack, 5);
            }
        } else if (!slotStack.isEmpty()) {
            newState = (BlockState)newState.setValue((Property)PROGRESS, (Comparable)Integer.valueOf((Integer)newState.getValue((Property)PROGRESS) + 1));
            this.triggerItemUseEffects(player, slotStack, 5);
        } else {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if ((Integer)newState.getValue((Property)PROGRESS) == 3) {
            newState = (BlockState)newState.setValue((Property)PROGRESS, (Comparable)Integer.valueOf(0));
            this.triggerItemUseEffects(player, slotStack, 16);
            player.eat(level, slotStack);
            plate.setItem(0, ItemStack.EMPTY);
        }
        level.setBlock(pos, newState, 3);
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PROGRESS});
    }

    private void triggerItemUseEffects(Player player, ItemStack stack, int amount) {
        if (stack.getUseAnimation() == UseAnim.DRINK) {
            player.playSound(stack.getDrinkingSound(), 0.5f, player.level().random.nextFloat() * 0.1f + 0.9f);
        }
        if (stack.getUseAnimation() == UseAnim.EAT) {
            RandomSource random = player.getRandom();
            for (int i = 0; i < amount; ++i) {
                Vec3 speed = new Vec3(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).xRot(-player.getXRot() * ((float)Math.PI / 180)).yRot(-player.getYRot() * ((float)Math.PI / 180));
                Vec3 pos = new Vec3(((double)random.nextFloat() - 0.5) * 0.3, (double)(-random.nextFloat()) * 0.6 - 0.3, 0.6).xRot(-player.getXRot() * ((float)Math.PI / 180)).yRot(-player.getYRot() * ((float)Math.PI / 180)).add(player.getX(), player.getEyeY(), player.getZ());
                player.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y, pos.z, speed.x, speed.y + 0.05, speed.z);
            }
            player.playSound(player.getEatingSound(stack), 0.5f + 0.5f * (float)random.nextInt(2), (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
        }
    }
}

