/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clock;

import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClockSyncPacket(BlockPos pos, boolean tickSound, List<ClockTrigger> triggers) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClockSyncPacket> TYPE = new CustomPacketPayload.Type(BCUtil.modLoc("clock_sync"));
    public static final StreamCodec<FriendlyByteBuf, ClockSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClockSyncPacket::pos, (StreamCodec)ByteBufCodecs.BOOL, ClockSyncPacket::tickSound, (StreamCodec)ClockTrigger.STREAM_CODEC.apply(ByteBufCodecs.list()), ClockSyncPacket::triggers, ClockSyncPacket::new);

    public static void handle(ClockSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos pos = packet.pos();
            Level level = context.player().level();
            if (!level.hasChunkAt(pos)) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof ClockBlockEntity)) {
                return;
            }
            ClockBlockEntity clock = (ClockBlockEntity)blockEntity;
            clock.setFromPacket(packet);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

