/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen.clock;

import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockTriggerElement;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.jetbrains.annotations.Nullable;

public class ClockTriggerPanel
extends ScrollPanel {
    public final ClockScreen owner;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    private final List<ClockTriggerElement> elements;

    public ClockTriggerPanel(int x, int y, int width, int height, List<ClockTrigger> triggers, ClockScreen owner) {
        super(Minecraft.getInstance(), width, height, y, x, 0);
        this.owner = owner;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.elements = new ArrayList<ClockTriggerElement>();
        this.rebuildElements(triggers);
    }

    protected int getContentHeight() {
        return this.elements.size() * 20;
    }

    protected void drawPanel(GuiGraphics graphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)this.left, (float)relativeY, 0.0f);
        for (int i = 0; i < this.elements.size(); ++i) {
            pose.pushPose();
            this.elements.get(i).render(graphics, mouseX - this.left, mouseY - i * 20 - relativeY, 1.0f);
            pose.popPose();
            pose.translate(0.0f, 20.0f, 0.0f);
        }
        pose.popPose();
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        ClockTriggerElement hovered = this.getHovered(mouseX, mouseY);
        if (hovered == null) {
            return;
        }
        float y = (float)(mouseY - this.top) + this.scrollDistance;
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)this.left, (float)mouseY, 0.0f);
        hovered.renderTooltip(graphics, mouseX - this.left, (int)(y % 20.0f));
        pose.popPose();
    }

    protected int getScrollAmount() {
        return this.hasScrollbar(this.elements.size()) ? 10 : 0;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.FOCUSED;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ClockTriggerElement hovered = this.getHovered(mouseX, mouseY);
        return hovered == null ? super.mouseClicked(mouseX, mouseY, button) : hovered.mouseClicked(mouseX - (double)this.left, (mouseY - (double)this.top + (double)this.scrollDistance) % 20.0, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        ClockTriggerElement hovered = this.getHovered(mouseX, mouseY);
        return hovered == null ? super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) : hovered.mouseDragged(mouseX - (double)this.left, (mouseY - (double)this.top + (double)this.scrollDistance) % 20.0, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        ClockTriggerElement hovered = this.getHovered(mouseX, mouseY);
        return hovered == null ? super.mouseReleased(mouseX, mouseY, button) : hovered.mouseReleased(mouseX - (double)this.left, (mouseY - (double)this.top + (double)this.scrollDistance) % 20.0, button);
    }

    public boolean mouseScrolled(double p_94686_, double p_94687_, double p_94688_, double p_294830_) {
        return this.hasScrollbar(this.elements.size()) && super.mouseScrolled(p_94686_, p_94687_, p_94688_, p_294830_);
    }

    public boolean hasScrollbar(int elements) {
        return elements * 20 > this.height;
    }

    public void rebuildElements(List<ClockTrigger> triggers) {
        this.elements.clear();
        for (int i = 0; i < triggers.size(); ++i) {
            this.elements.add(new ClockTriggerElement(triggers.get(i), this, triggers.size()));
        }
    }

    @Nullable
    public ClockTriggerElement getHovered(double mouseX, double mouseY) {
        double x = mouseX - (double)this.left;
        if (x < 0.0 || x >= (double)this.width) {
            return null;
        }
        double y = mouseY - (double)this.top + (double)this.scrollDistance;
        if (y < (double)this.scrollDistance || y >= (double)((float)this.height + this.scrollDistance)) {
            return null;
        }
        int index = (int)(y / 20.0);
        return index < 0 || index >= this.elements.size() ? null : this.elements.get(index);
    }
}

