/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen.clock;

import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockScreen;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClockTriggerEditScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = BCUtil.modLoc("textures/gui/clock_edit.png");
    private static final Component TITLE = Component.translatable((String)"gui.bibliocraft.clock.title");
    private static final Component EMIT_REDSTONE = Component.translatable((String)"gui.bibliocraft.clock.emit_redstone");
    private static final Component EMIT_SOUND = Component.translatable((String)"gui.bibliocraft.clock.emit_sound");
    private static final Component HOURS = Component.translatable((String)"gui.bibliocraft.clock.hours");
    private static final Component HOURS_HINT = Component.translatable((String)"gui.bibliocraft.clock.hours_hint");
    private static final Component MINUTES = Component.translatable((String)"gui.bibliocraft.clock.minutes");
    private static final Component MINUTES_HINT = Component.translatable((String)"gui.bibliocraft.clock.minutes_hint");
    private static final Component TIME = Component.translatable((String)"gui.bibliocraft.clock.time");
    private static final Component TIME_SEPARATOR = Component.translatable((String)"gui.bibliocraft.clock.time_separator");
    private static final int WIDTH = 144;
    private static final int HEIGHT = 72;
    private final ClockScreen parent;
    @Nullable
    private final ClockTrigger old;
    private final int timeWidth;
    private final int separatorWidth;
    private final int redstoneWidth;
    private final int soundWidth;
    private int leftPos;
    private int topPos;
    private int contentLeftPos;
    private int contentTopPos;
    private EditBox hours;
    private EditBox minutes;
    private Checkbox redstone;
    private Checkbox sound;

    public ClockTriggerEditScreen(ClockScreen parent, @Nullable ClockTrigger old) {
        super(TITLE);
        this.parent = parent;
        this.old = old;
        Font font = Minecraft.getInstance().font;
        this.timeWidth = font.width((FormattedText)TIME);
        this.separatorWidth = font.width((FormattedText)TIME_SEPARATOR);
        this.redstoneWidth = font.width((FormattedText)EMIT_REDSTONE);
        this.soundWidth = font.width((FormattedText)EMIT_SOUND);
    }

    protected void init() {
        this.leftPos = (this.width - 144) / 2;
        this.topPos = (this.height - 72) / 2;
        this.contentLeftPos = (this.width - Math.min(132, BCUtil.max(this.timeWidth + this.separatorWidth + 90, this.redstoneWidth + 19, this.soundWidth + 19))) / 2;
        this.contentTopPos = this.topPos + 6;
        Font font = Minecraft.getInstance().font;
        this.hours = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(font, this.contentLeftPos + this.timeWidth + 2, this.contentTopPos, 40, 20, HOURS));
        this.hours.setHint(HOURS_HINT);
        this.hours.setFilter(s -> {
            try {
                int i = Integer.parseInt(s);
                return i >= 0 && i < 24;
            }
            catch (NumberFormatException e) {
                return s.isEmpty();
            }
        });
        this.minutes = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(font, this.contentLeftPos + this.timeWidth + this.separatorWidth + 44, this.contentTopPos, 40, 20, MINUTES));
        this.minutes.setHint(MINUTES_HINT);
        this.minutes.setFilter(s -> {
            try {
                int i = Integer.parseInt(s);
                return i >= 0 && i < 60;
            }
            catch (NumberFormatException e) {
                return s.isEmpty();
            }
        });
        this.redstone = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.empty(), (Font)font).pos(this.contentLeftPos, this.contentTopPos + 22).build());
        this.sound = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.empty(), (Font)font).pos(this.contentLeftPos, this.contentTopPos + 41).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> {
            try {
                if (this.old != null) {
                    this.parent.removeTrigger(this.old);
                }
                this.parent.addTrigger(new ClockTrigger(Integer.parseInt(this.hours.getValue()), Integer.parseInt(this.minutes.getValue()), this.redstone.selected(), this.sound.selected()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.onClose();
        }).bounds(this.leftPos, this.topPos + 72 + 4, 144, 20).build());
        if (this.old != null) {
            this.hours.setValue(String.valueOf(this.old.hour()));
            this.minutes.setValue(String.valueOf(this.old.minute()));
            if (this.old.redstone()) {
                this.redstone.onPress();
            }
            if (this.old.sound()) {
                this.sound.onPress();
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawString(Minecraft.getInstance().font, TIME, this.contentLeftPos, this.contentTopPos + 6, 0x404040, false);
        graphics.drawString(Minecraft.getInstance().font, TIME_SEPARATOR, this.contentLeftPos + this.timeWidth + 43, this.contentTopPos + 6, 0x404040, false);
        graphics.drawString(Minecraft.getInstance().font, EMIT_REDSTONE, this.contentLeftPos + 19, this.contentTopPos + 27, 0x404040, false);
        graphics.drawString(Minecraft.getInstance().font, EMIT_SOUND, this.contentLeftPos + 19, this.contentTopPos + 46, 0x404040, false);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 144, 72);
    }
}

