/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen.clock;

import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockTriggerEditScreen;
import com.github.minecraftschurlimods.bibliocraft.client.screen.clock.ClockTriggerPanel;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockSyncPacket;
import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockTrigger;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClockScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = BCUtil.modLoc("textures/gui/clock.png");
    private static final Component ADD_TRIGGER = Component.translatable((String)"gui.bibliocraft.clock.add_trigger");
    private static final Component TICK = Component.translatable((String)"gui.bibliocraft.clock.tick");
    private static final Component TITLE = Component.translatable((String)"gui.bibliocraft.clock.title");
    private static final Component TRIGGERS = Component.translatable((String)"gui.bibliocraft.clock.triggers");
    private static final int IMAGE_WIDTH = 176;
    private static final int IMAGE_HEIGHT = 166;
    private final BlockPos pos;
    private final ClockBlockEntity clock;
    private final List<ClockTrigger> triggers;
    private int leftPos;
    private int topPos;
    private Checkbox tickSound;
    private ClockTriggerPanel triggerPanel;

    public ClockScreen(BlockPos pos) {
        super(TITLE);
        this.pos = pos;
        this.clock = (ClockBlockEntity)Objects.requireNonNull(Objects.requireNonNull(Minecraft.getInstance().level).getBlockEntity(pos));
        this.triggers = new ArrayList<ClockTrigger>(this.clock.getTriggers());
    }

    protected void init() {
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 166) / 2;
        this.tickSound = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.empty(), (Font)Minecraft.getInstance().font).pos(this.leftPos + 7, this.topPos + 6).selected(this.clock.tickSound).build());
        this.triggerPanel = (ClockTriggerPanel)this.addRenderableWidget((GuiEventListener)new ClockTriggerPanel(this.leftPos + 8, this.topPos + 36, 160, 122, this.triggers, this));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)ADD_TRIGGER, $ -> Minecraft.getInstance().pushGuiLayer((Screen)new ClockTriggerEditScreen(this, null))).bounds(this.width / 2 - 100, this.topPos + 170, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, $ -> this.onClose()).bounds(this.width / 2 + 2, this.topPos + 170, 98, 20).build());
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ClockSyncPacket(this.pos, this.tickSound.selected(), this.triggers), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawString(Minecraft.getInstance().font, TICK, this.leftPos + 28, this.topPos + 11, 0x404040, false);
        graphics.drawString(Minecraft.getInstance().font, TRIGGERS, this.leftPos + 8, this.topPos + 26, 0x404040, false);
        this.triggerPanel.renderTooltip(graphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, 176, 166);
    }

    public void addTrigger(ClockTrigger trigger) {
        this.triggers.add(trigger);
        this.triggers.sort(ClockTrigger::compareTo);
        this.triggerPanel.rebuildElements(this.triggers);
    }

    public void removeTrigger(ClockTrigger trigger) {
        this.triggers.remove(trigger);
        this.triggers.sort(ClockTrigger::compareTo);
        this.triggerPanel.rebuildElements(this.triggers);
    }
}

