/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.content.slottedbook.SlottedBookMenu;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SlottedBookScreen
extends AbstractContainerScreen<SlottedBookMenu> {
    private static final Component TITLE = Component.translatable((String)"item.bibliocraft.slotted_book.title");
    private static final Component TEXT = Component.translatable((String)"item.bibliocraft.slotted_book.text");
    private static final ResourceLocation BACKGROUND = BCUtil.modLoc("textures/gui/slotted_book.png");

    public SlottedBookScreen(SlottedBookMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageHeight = 223;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    public void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        super.render(graphics, mouseX, mouseY, partialTick);
        FormattedText text = FormattedText.of((String)TEXT.getString());
        List lines = this.font.split(text, 114);
        int startX = (this.width - 192) / 2;
        int startY = this.topPos + 111 - lines.size() * 9;
        for (int i = 0; i < lines.size(); ++i) {
            graphics.drawString(this.font, (FormattedCharSequence)lines.get(i), startX + 38, startY + i * 9, 0, false);
        }
        this.renderTooltip(graphics, mouseX, mouseY);
    }
}

