/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.screen;

import com.github.minecraftschurlimods.bibliocraft.client.screen.BCMenuScreen;
import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterMenu;
import com.github.minecraftschurlimods.bibliocraft.content.fancycrafter.FancyCrafterSlot;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FancyCrafterScreen
extends BCMenuScreen<FancyCrafterMenu> {
    private static final ResourceLocation BACKGROUND = BCUtil.modLoc("textures/gui/fancy_crafter.png");
    private static final ResourceLocation DISABLED_SLOT = BCUtil.mcLoc("container/crafter/disabled_slot");
    private static final Component DISABLED_SLOT_TOOLTIP = Component.translatable((String)"gui.togglable_slot");
    private final Player player;

    public FancyCrafterScreen(FancyCrafterMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, BACKGROUND);
        this.player = inventory.player;
        this.imageHeight = 192;
        this.inventoryLabelY = 99;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.hoveredSlot instanceof FancyCrafterSlot && !((FancyCrafterMenu)this.menu).isSlotDisabled(this.hoveredSlot.index) && ((FancyCrafterMenu)this.menu).getCarried().isEmpty() && !this.hoveredSlot.hasItem() && !this.player.isSpectator()) {
            guiGraphics.renderTooltip(this.font, DISABLED_SLOT_TOOLTIP, mouseX, mouseY);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof FancyCrafterSlot && ((FancyCrafterMenu)this.menu).isSlotDisabled(slot.index)) {
            guiGraphics.blitSprite(DISABLED_SLOT, slot.x - 1, slot.y - 1, 18, 18);
        }
        super.renderSlot(guiGraphics, slot);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof FancyCrafterSlot && !slot.hasItem() && !this.player.isSpectator()) {
            switch (type) {
                case PICKUP: {
                    if (((FancyCrafterMenu)this.menu).isSlotDisabled(slotId)) {
                        this.updateSlotState(slotId, false);
                        break;
                    }
                    if (!((FancyCrafterMenu)this.menu).getCarried().isEmpty()) break;
                    this.updateSlotState(slotId, true);
                    break;
                }
                case SWAP: {
                    ItemStack stack = this.player.getInventory().getItem(mouseButton);
                    if (!((FancyCrafterMenu)this.menu).isSlotDisabled(slotId) || stack.isEmpty()) break;
                    this.updateSlotState(slotId, false);
                }
            }
        }
        super.slotClicked(slot, slotId, mouseButton, type);
    }

    private void updateSlotState(int slot, boolean disabled) {
        ((FancyCrafterMenu)this.menu).setSlotDisabled(slot, disabled);
        this.handleSlotStateChanged(slot, ((FancyCrafterMenu)this.menu).containerId, disabled);
        this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.4f, disabled ? 0.75f : 1.0f);
    }
}

