/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client.ber;

import com.github.minecraftschurlimods.bibliocraft.content.clock.ClockBlockEntity;
import com.github.minecraftschurlimods.bibliocraft.content.clock.FancyClockBlock;
import com.github.minecraftschurlimods.bibliocraft.content.clock.GrandfatherClockBlock;
import com.github.minecraftschurlimods.bibliocraft.content.clock.WallFancyClockBlock;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.Level;

public class ClockBER
implements BlockEntityRenderer<ClockBlockEntity> {
    public static final Material HAND_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BCUtil.modLoc("block/clock_hand"));
    public static final Material PENDULUM_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, BCUtil.mcLoc("block/copper_block"));
    public static final ModelLayerLocation LOCATION = new ModelLayerLocation(BCUtil.modLoc("clock"), "main");
    private final ModelPart hourHand;
    private final ModelPart minuteHand;
    private final ModelPart pendulum;
    private final ModelPart grandfatherHourHand;
    private final ModelPart grandfatherMinuteHand;
    private final ModelPart grandfatherPendulum;
    private float rotation;
    private float rotationOld;
    private long lastUpdateTick;

    public ClockBER(BlockEntityRendererProvider.Context context) {
        ModelPart model = context.bakeLayer(LOCATION);
        this.hourHand = model.getChild("hour");
        this.minuteHand = model.getChild("minute");
        this.pendulum = model.getChild("pendulum");
        this.grandfatherHourHand = model.getChild("grandfather_hour");
        this.grandfatherMinuteHand = model.getChild("grandfather_minute");
        this.grandfatherPendulum = model.getChild("grandfather_pendulum");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("hour", CubeListBuilder.create().addBox(-0.25f, -0.25f, -0.25f, 0.5f, 1.5f, 0.5f), PartPose.ZERO);
        root.addOrReplaceChild("minute", CubeListBuilder.create().addBox(-0.25f, -0.25f, -0.25f, 0.5f, 2.0f, 0.5f), PartPose.ZERO);
        PartDefinition pendulum = root.addOrReplaceChild("pendulum", CubeListBuilder.create().addBox(-0.25f, 0.0f, -0.25f, 0.5f, 2.0f, 0.5f), PartPose.ZERO);
        pendulum.addOrReplaceChild("head", CubeListBuilder.create().texOffs(7, 7).addBox(-1.0f, 2.0f, -0.5f, 2.0f, 2.0f, 1.0f), PartPose.ZERO);
        root.addOrReplaceChild("grandfather_hour", CubeListBuilder.create().addBox(-0.25f, -0.25f, -0.25f, 0.5f, 2.0f, 0.5f), PartPose.ZERO);
        root.addOrReplaceChild("grandfather_minute", CubeListBuilder.create().addBox(-0.25f, -0.25f, -0.25f, 0.5f, 2.5f, 0.5f), PartPose.ZERO);
        PartDefinition grandfatherPendulum = root.addOrReplaceChild("grandfather_pendulum", CubeListBuilder.create().addBox(-0.25f, 0.0f, -0.25f, 0.5f, 15.0f, 0.5f), PartPose.ZERO);
        grandfatherPendulum.addOrReplaceChild("grandfather_head", CubeListBuilder.create().texOffs(7, 7).addBox(-1.0f, 15.0f, -0.5f, 2.0f, 2.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)16, (int)16);
    }

    public void render(ClockBlockEntity blockEntity, float partialTick, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer handMaterial = HAND_MATERIAL.buffer(buffer, RenderType::entityCutout);
        VertexConsumer pendulumMaterial = PENDULUM_MATERIAL.buffer(buffer, RenderType::entityCutout);
        stack.pushPose();
        ClientUtil.setupCenteredBER(stack, blockEntity);
        if (blockEntity.getBlockState().getBlock() instanceof FancyClockBlock) {
            this.renderHands(blockEntity, this.hourHand, this.minuteHand, 0.15625, 0.15625, stack, handMaterial, light, overlay);
            this.renderPendulum(blockEntity, this.pendulum, 4.0f, -0.0625, 0.09375, stack, pendulumMaterial, light, overlay);
        } else if (blockEntity.getBlockState().getBlock() instanceof WallFancyClockBlock) {
            this.renderHands(blockEntity, this.hourHand, this.minuteHand, 0.15625, -0.15625, stack, handMaterial, light, overlay);
            this.renderPendulum(blockEntity, this.pendulum, 4.0f, -0.0625, -0.21875, stack, pendulumMaterial, light, overlay);
        } else if (blockEntity.getBlockState().getBlock() instanceof GrandfatherClockBlock) {
            this.renderHands(blockEntity, this.grandfatherHourHand, this.grandfatherMinuteHand, 0.125, 0.15625, stack, handMaterial, light, overlay);
            this.renderPendulum(blockEntity, this.grandfatherPendulum, 17.0f, -0.125, 0.09375, stack, pendulumMaterial, light, overlay);
        }
        stack.popPose();
    }

    private void renderHands(ClockBlockEntity blockEntity, ModelPart hourHand, ModelPart minuteHand, double y, double z, PoseStack stack, VertexConsumer vc, int light, int overlay) {
        Level level = Objects.requireNonNull(blockEntity.getLevel());
        float rotation = level.dimensionType().natural() ? (float)(-((level.getDayTime() + 6000L) % 12000L)) * 0.03f : this.getRotation(level);
        stack.pushPose();
        stack.translate(0.0, y, z);
        stack.pushPose();
        stack.mulPose(Axis.ZP.rotationDegrees(rotation));
        hourHand.render(stack, vc, light, overlay);
        stack.popPose();
        stack.pushPose();
        stack.mulPose(Axis.ZP.rotationDegrees(rotation * 12.0f % 360.0f));
        minuteHand.render(stack, vc, light, overlay);
        stack.popPose();
        stack.popPose();
    }

    private void renderPendulum(ClockBlockEntity blockEntity, ModelPart pendulum, float pendulumSize, double y, double z, PoseStack stack, VertexConsumer vc, int light, int overlay) {
        float rotation = (float)Math.sin((double)(Objects.requireNonNull(blockEntity.getLevel()).getDayTime() % 40L - 20L) * Math.PI / 20.0);
        stack.pushPose();
        stack.translate(0.0, y, z);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        stack.mulPose(Axis.ZP.rotation(rotation / pendulumSize));
        pendulum.render(stack, vc, light, overlay);
        stack.popPose();
    }

    private float getRotation(Level level) {
        float rotationNew = (float)Math.random();
        if (level.getGameTime() != this.lastUpdateTick) {
            this.lastUpdateTick = level.getGameTime();
            float f = rotationNew - this.rotation;
            f = Mth.positiveModulo((float)(f + 0.5f), (float)1.0f) - 0.5f;
            this.rotationOld += f * 0.1f;
            this.rotationOld *= 0.9f;
            this.rotation = Mth.positiveModulo((float)(this.rotation + this.rotationOld), (float)1.0f);
        }
        return this.rotation * (float)Math.PI * 4.0f;
    }
}

