/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class SpriteButton
extends Button {
    public SpriteButton(int x, int y, int width, int height, Button.OnPress onPress) {
        super(new Button.Builder((Component)Component.empty(), onPress).bounds(x, y, width, height));
    }

    @Nullable
    protected abstract ResourceLocation getSprite();

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation sprite = this.getSprite();
        if (sprite != null) {
            guiGraphics.blitSprite(sprite, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public static class RegularAndHighlightSprite
    extends SpriteButton {
        private final ResourceLocation sprite;
        private final ResourceLocation highlightedSprite;

        public RegularAndHighlightSprite(ResourceLocation sprite, ResourceLocation highlightedSprite, int x, int y, int width, int height, Button.OnPress onPress) {
            super(x, y, width, height, onPress);
            this.sprite = sprite;
            this.highlightedSprite = highlightedSprite;
        }

        @Override
        protected ResourceLocation getSprite() {
            return this.isHoveredOrFocused() ? this.highlightedSprite : this.sprite;
        }
    }
}

