/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.apiimpl;

import com.github.minecraftschurlimods.bibliocraft.api.datagen.BibliocraftDatagenHelper;
import com.github.minecraftschurlimods.bibliocraft.api.datagen.BlockLootTableProvider;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.client.model.TableModel;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackBlock;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackItem;
import com.github.minecraftschurlimods.bibliocraft.content.seat.SeatBackType;
import com.github.minecraftschurlimods.bibliocraft.content.table.TableBlock;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlocks;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.init.BCTags;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.DatagenUtil;
import com.github.minecraftschurlimods.bibliocraft.util.init.ColoredWoodTypeDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.init.WoodTypeDeferredHolder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.ApiStatus;

public final class BibliocraftDatagenHelperImpl
implements BibliocraftDatagenHelper {
    private final List<BibliocraftWoodType> WOOD_TYPES = new ArrayList<BibliocraftWoodType>();

    @ApiStatus.Internal
    public BibliocraftDatagenHelperImpl() {
    }

    @Override
    public synchronized void addWoodTypeToGenerate(BibliocraftWoodType woodType) {
        this.WOOD_TYPES.add(woodType);
    }

    @Override
    public List<BibliocraftWoodType> getWoodTypesToGenerate() {
        return Collections.unmodifiableList(this.WOOD_TYPES);
    }

    @Override
    public void generateAllFor(final BibliocraftWoodType woodType, final String modId, GatherDataEvent event, LanguageProvider englishLanguageProvider, BlockTagsProvider blockTagsProvider, ItemTagsProvider itemTagsProvider) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        this.generateEnglishTranslationsFor(englishLanguageProvider, woodType);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateProvider(output, "bibliocraft", existingFileHelper){

            protected void registerStatesAndModels() {
                BibliocraftDatagenHelperImpl.this.generateBlockStatesFor(this, woodType);
            }

            public String getName() {
                return super.getName() + " (Bibliocraft datagen helper for wood type " + String.valueOf(woodType.id()) + ")";
            }
        });
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(output, "bibliocraft", existingFileHelper){

            protected void registerModels() {
                BibliocraftDatagenHelperImpl.this.generateItemModelsFor(this, woodType);
            }

            public String getName() {
                return super.getName() + " (Bibliocraft datagen helper for wood type " + String.valueOf(woodType.id()) + ")";
            }
        });
        generator.addProvider(event.includeServer(), (DataProvider)new BlockLootTableProvider(output, lookupProvider){

            @Override
            protected void generate() {
                BibliocraftDatagenHelperImpl.this.generateLootTablesFor(this, woodType);
            }

            @Override
            public String getName() {
                return super.getName() + " (Bibliocraft datagen helper for wood type " + String.valueOf(woodType.id()) + ")";
            }
        });
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, lookupProvider){

            protected void buildRecipes(RecipeOutput output) {
                BibliocraftDatagenHelperImpl.this.generateRecipesFor(output, woodType, modId);
            }

            public String getName() {
                return super.getName() + " (Bibliocraft datagen helper for wood type " + String.valueOf(woodType.id()) + ")";
            }
        });
        this.generateBlockTagsFor(arg_0 -> ((BlockTagsProvider)blockTagsProvider).tag(arg_0), woodType);
        this.generateItemTagsFor(arg_0 -> ((ItemTagsProvider)itemTagsProvider).tag(arg_0), woodType);
    }

    @Override
    public void generateEnglishTranslationsFor(LanguageProvider provider, BibliocraftWoodType woodType) {
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.BOOKCASE, "Bookcase");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.FANCY_ARMOR_STAND, "Fancy Armor Stand");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.FANCY_CLOCK, "Fancy Clock");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.WALL_FANCY_CLOCK, "Fancy Clock");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.FANCY_CRAFTER, "Fancy Crafter");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.GRANDFATHER_CLOCK, "Grandfather Clock");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.LABEL, "Label");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.POTION_SHELF, "Potion Shelf");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.SHELF, "Shelf");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.TABLE, "Table");
        BibliocraftDatagenHelperImpl.woodenBlockTranslation(provider, woodType, BCBlocks.TOOL_RACK, "Tool Rack");
        for (DyeColor color : DyeColor.values()) {
            BibliocraftDatagenHelperImpl.coloredWoodenBlockTranslation(provider, woodType, color, BCBlocks.DISPLAY_CASE, "Display Case");
            BibliocraftDatagenHelperImpl.coloredWoodenBlockTranslation(provider, woodType, color, BCBlocks.WALL_DISPLAY_CASE, "Display Case");
            BibliocraftDatagenHelperImpl.coloredWoodenBlockTranslation(provider, woodType, color, BCBlocks.SEAT, "Seat");
            BibliocraftDatagenHelperImpl.coloredWoodenBlockTranslation(provider, woodType, color, BCBlocks.SEAT_BACK, "Seat Back");
            BibliocraftDatagenHelperImpl.coloredWoodenItemTranslation(provider, woodType, color, BCItems.SMALL_SEAT_BACK, "Small Seat Back");
            BibliocraftDatagenHelperImpl.coloredWoodenItemTranslation(provider, woodType, color, BCItems.RAISED_SEAT_BACK, "Raised Seat Back");
            BibliocraftDatagenHelperImpl.coloredWoodenItemTranslation(provider, woodType, color, BCItems.FLAT_SEAT_BACK, "Flat Seat Back");
            BibliocraftDatagenHelperImpl.coloredWoodenItemTranslation(provider, woodType, color, BCItems.TALL_SEAT_BACK, "Tall Seat Back");
            BibliocraftDatagenHelperImpl.coloredWoodenItemTranslation(provider, woodType, color, BCItems.FANCY_SEAT_BACK, "Fancy Seat Back");
        }
    }

    @Override
    public void generateBlockStatesFor(BlockStateProvider provider, BibliocraftWoodType woodType) {
        BlockModelProvider models = provider.models();
        ResourceLocation woodTexture = woodType.texture();
        String prefix = "block/wood/" + woodType.getRegistrationPrefix() + "/";
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.BOOKCASE.holder(woodType), prefix + "bookcase", BibliocraftDatagenHelperImpl.bcLoc("block/template/bookcase/bookcase"), woodTexture);
        DatagenUtil.doubleHighHorizontalBlockModel(provider, BCBlocks.FANCY_ARMOR_STAND.holder(woodType), (ModelFile)((BlockModelBuilder)models.withExistingParent(prefix + "fancy_armor_stand_bottom", BibliocraftDatagenHelperImpl.bcLoc("block/template/fancy_armor_stand/bottom"))).texture("texture", woodTexture), (ModelFile)((BlockModelBuilder)models.withExistingParent(prefix + "fancy_armor_stand_top", BibliocraftDatagenHelperImpl.bcLoc("block/template/fancy_armor_stand/top"))).texture("texture", woodTexture), true);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.FANCY_CLOCK.holder(woodType), prefix + "fancy_clock", BibliocraftDatagenHelperImpl.bcLoc("block/template/clock/fancy"), woodTexture);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.WALL_FANCY_CLOCK.holder(woodType), prefix + "wall_fancy_clock", BibliocraftDatagenHelperImpl.bcLoc("block/template/clock/wall_fancy"), woodTexture);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.FANCY_CRAFTER.holder(woodType), prefix + "fancy_crafter", BibliocraftDatagenHelperImpl.bcLoc("block/template/fancy_crafter"), woodTexture);
        DatagenUtil.doubleHighHorizontalBlockModel(provider, BCBlocks.GRANDFATHER_CLOCK.holder(woodType), (ModelFile)((BlockModelBuilder)models.withExistingParent(prefix + "grandfather_clock_bottom", BibliocraftDatagenHelperImpl.bcLoc("block/template/clock/grandfather_bottom"))).texture("texture", woodTexture), (ModelFile)((BlockModelBuilder)models.withExistingParent(prefix + "grandfather_clock_top", BibliocraftDatagenHelperImpl.bcLoc("block/template/clock/grandfather_top"))).texture("texture", woodTexture), true);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.LABEL.holder(woodType), prefix + "label", BibliocraftDatagenHelperImpl.bcLoc("block/template/label"), woodTexture);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.POTION_SHELF.holder(woodType), prefix + "potion_shelf", BibliocraftDatagenHelperImpl.bcLoc("block/template/potion_shelf"), woodTexture);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.SHELF.holder(woodType), prefix + "shelf", BibliocraftDatagenHelperImpl.bcLoc("block/template/shelf"), woodTexture);
        TableModel.Builder tableBuilder = ((TableModel.Builder)((BlockModelBuilder)models.getBuilder(prefix + "table")).customLoader(TableModel.Builder::new)).withParticle(woodTexture);
        for (TableBlock.Type type : TableBlock.Type.values()) {
            String name = type.getSerializedName();
            JsonObject model = new JsonObject();
            model.addProperty("parent", BibliocraftDatagenHelperImpl.bcLoc("block/template/table/" + name).toString());
            JsonObject textures = new JsonObject();
            textures.addProperty("texture", woodTexture.toString());
            model.add("textures", (JsonElement)textures);
            tableBuilder.withModelForType(type, model);
        }
        ((BlockModelBuilder)models.withExistingParent(prefix + "table_inventory", BibliocraftDatagenHelperImpl.bcLoc("block/template/table/none"))).texture("texture", woodTexture);
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.TABLE.holder(woodType), state -> models.getExistingFile(provider.modLoc(prefix + "table")));
        DatagenUtil.horizontalBlockModel(provider, BCBlocks.TOOL_RACK.holder(woodType), prefix + "tool_rack", BibliocraftDatagenHelperImpl.bcLoc("block/template/tool_rack"), woodTexture);
        for (TableBlock.Type type : DyeColor.values()) {
            String colorPrefix;
            ResourceLocation wool = DatagenUtil.WOOL_TEXTURES.get((Object)type);
            Object holder = BCBlocks.DISPLAY_CASE.holder(woodType, (DyeColor)type);
            String finalColorPrefix = colorPrefix = "block/color/" + type.getSerializedName() + "/wood/" + woodType.getRegistrationPrefix() + "/";
            DatagenUtil.openClosedHorizontalBlockModel(provider, holder, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(colorPrefix + "display_case_open", BibliocraftDatagenHelperImpl.bcLoc("block/template/display_case/open"))).texture("texture", woodTexture)).texture("color", wool), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(colorPrefix + "display_case_closed", BibliocraftDatagenHelperImpl.bcLoc("block/template/display_case/closed"))).texture("texture", woodTexture)).texture("color", wool), false);
            holder = BCBlocks.WALL_DISPLAY_CASE.holder(woodType, (DyeColor)type);
            DatagenUtil.openClosedHorizontalBlockModel(provider, holder, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(colorPrefix + "wall_display_case_open", BibliocraftDatagenHelperImpl.bcLoc("block/template/display_case/wall_open"))).texture("texture", woodTexture)).texture("color", wool), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(colorPrefix + "wall_display_case_closed", BibliocraftDatagenHelperImpl.bcLoc("block/template/display_case/wall_closed"))).texture("texture", woodTexture)).texture("color", wool), true);
            holder = BCBlocks.SEAT.holder(woodType, (DyeColor)type);
            provider.getVariantBuilder((Block)holder.get()).forAllStates(arg_0 -> BibliocraftDatagenHelperImpl.lambda$generateBlockStatesFor$1(models, finalColorPrefix, woodTexture, (DyeColor)type, arg_0));
            DatagenUtil.horizontalBlockModel(provider, BCBlocks.SEAT_BACK.holder(woodType, (DyeColor)type), arg_0 -> BibliocraftDatagenHelperImpl.lambda$generateBlockStatesFor$2(models, finalColorPrefix, woodTexture, (DyeColor)type, arg_0), true);
        }
    }

    @Override
    public void generateItemModelsFor(ItemModelProvider provider, BibliocraftWoodType woodType) {
        String prefix = woodType.getRegistrationPrefix();
        provider.withExistingParent(prefix + "_bookcase", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/bookcase"));
        ((ItemModelBuilder)provider.withExistingParent(prefix + "_fancy_armor_stand", BibliocraftDatagenHelperImpl.bcLoc("block/template/fancy_armor_stand/inventory"))).texture("texture", woodType.texture());
        ((ItemModelBuilder)provider.withExistingParent(prefix + "_fancy_clock", BibliocraftDatagenHelperImpl.bcLoc("block/template/clock/fancy_inventory"))).texture("texture", woodType.texture());
        provider.withExistingParent(prefix + "_fancy_crafter", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/fancy_crafter"));
        ((ItemModelBuilder)provider.withExistingParent(prefix + "_grandfather_clock", BibliocraftDatagenHelperImpl.bcLoc("block/template/clock/grandfather_inventory"))).texture("texture", woodType.texture());
        provider.withExistingParent(prefix + "_label", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/label"));
        provider.withExistingParent(prefix + "_potion_shelf", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/potion_shelf"));
        provider.withExistingParent(prefix + "_shelf", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/shelf"));
        provider.withExistingParent(prefix + "_table", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/table_inventory"));
        provider.withExistingParent(prefix + "_tool_rack", BibliocraftDatagenHelperImpl.bcLoc("block/wood/" + prefix + "/tool_rack"));
        for (DyeColor color : DyeColor.values()) {
            provider.withExistingParent(BCItems.DISPLAY_CASE.holder(woodType, color).getId().getPath(), BibliocraftDatagenHelperImpl.bcLoc("block/color/" + color.getSerializedName() + "/wood/" + woodType.getRegistrationPrefix() + "/display_case_open"));
            provider.withExistingParent(BCItems.SEAT.holder(woodType, color).getId().getPath(), BibliocraftDatagenHelperImpl.bcLoc("block/color/" + color.getSerializedName() + "/wood/" + woodType.getRegistrationPrefix() + "/seat"));
            BibliocraftDatagenHelperImpl.seatBackItemModel(provider, BCItems.SMALL_SEAT_BACK.get(woodType, color));
            BibliocraftDatagenHelperImpl.seatBackItemModel(provider, BCItems.RAISED_SEAT_BACK.get(woodType, color));
            BibliocraftDatagenHelperImpl.seatBackItemModel(provider, BCItems.FLAT_SEAT_BACK.get(woodType, color));
            BibliocraftDatagenHelperImpl.seatBackItemModel(provider, BCItems.TALL_SEAT_BACK.get(woodType, color));
            BibliocraftDatagenHelperImpl.seatBackItemModel(provider, BCItems.FANCY_SEAT_BACK.get(woodType, color));
        }
    }

    @Override
    public void generateBlockTagsFor(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAccessor, BibliocraftWoodType woodType) {
        if (woodType.getNamespace().equals("minecraft")) {
            tagAccessor.apply(BCTags.Blocks.BOOKCASES).add((Object)BCBlocks.BOOKCASE.get(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_ARMOR_STANDS_WOOD).add((Object)BCBlocks.FANCY_ARMOR_STAND.get(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_CLOCKS).add((Object)BCBlocks.FANCY_CLOCK.get(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_CLOCKS).add((Object)BCBlocks.WALL_FANCY_CLOCK.get(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_CRAFTERS).add((Object)BCBlocks.FANCY_CRAFTER.get(woodType));
            tagAccessor.apply(BCTags.Blocks.GRANDFATHER_CLOCKS).add((Object)BCBlocks.GRANDFATHER_CLOCK.get(woodType));
            tagAccessor.apply(BCTags.Blocks.LABELS).add((Object)BCBlocks.LABEL.get(woodType));
            tagAccessor.apply(BCTags.Blocks.POTION_SHELVES).add((Object)BCBlocks.POTION_SHELF.get(woodType));
            tagAccessor.apply(BCTags.Blocks.SHELVES).add((Object)BCBlocks.SHELF.get(woodType));
            tagAccessor.apply(BCTags.Blocks.TABLES).add((Object)BCBlocks.TABLE.get(woodType));
            tagAccessor.apply(BCTags.Blocks.TOOL_RACKS).add((Object)BCBlocks.TOOL_RACK.get(woodType));
            DatagenUtil.addAll(BuiltInRegistries.BLOCK, BCBlocks.DISPLAY_CASE.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.DISPLAY_CASES));
            DatagenUtil.addAll(BuiltInRegistries.BLOCK, BCBlocks.WALL_DISPLAY_CASE.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.DISPLAY_CASES));
            DatagenUtil.addAll(BuiltInRegistries.BLOCK, BCBlocks.SEAT.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.SEATS));
            DatagenUtil.addAll(BuiltInRegistries.BLOCK, BCBlocks.SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.SEAT_BACKS));
        } else {
            tagAccessor.apply(BCTags.Blocks.BOOKCASES).addOptional(BCBlocks.BOOKCASE.id(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_ARMOR_STANDS_WOOD).addOptional(BCBlocks.FANCY_ARMOR_STAND.id(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_CLOCKS).addOptional(BCBlocks.FANCY_CLOCK.id(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_CLOCKS).addOptional(BCBlocks.WALL_FANCY_CLOCK.id(woodType));
            tagAccessor.apply(BCTags.Blocks.FANCY_CRAFTERS).addOptional(BCBlocks.FANCY_CRAFTER.id(woodType));
            tagAccessor.apply(BCTags.Blocks.GRANDFATHER_CLOCKS).addOptional(BCBlocks.GRANDFATHER_CLOCK.id(woodType));
            tagAccessor.apply(BCTags.Blocks.LABELS).addOptional(BCBlocks.LABEL.id(woodType));
            tagAccessor.apply(BCTags.Blocks.POTION_SHELVES).addOptional(BCBlocks.POTION_SHELF.id(woodType));
            tagAccessor.apply(BCTags.Blocks.SHELVES).addOptional(BCBlocks.SHELF.id(woodType));
            tagAccessor.apply(BCTags.Blocks.TABLES).addOptional(BCBlocks.TABLE.id(woodType));
            tagAccessor.apply(BCTags.Blocks.TOOL_RACKS).addOptional(BCBlocks.TOOL_RACK.id(woodType));
            DatagenUtil.addAllOptional(BuiltInRegistries.BLOCK, BCBlocks.DISPLAY_CASE.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.DISPLAY_CASES));
            DatagenUtil.addAllOptional(BuiltInRegistries.BLOCK, BCBlocks.WALL_DISPLAY_CASE.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.DISPLAY_CASES));
            DatagenUtil.addAllOptional(BuiltInRegistries.BLOCK, BCBlocks.SEAT.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.SEATS));
            DatagenUtil.addAllOptional(BuiltInRegistries.BLOCK, BCBlocks.SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Blocks.SEAT_BACKS));
        }
    }

    @Override
    public void generateItemTagsFor(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagAccessor, BibliocraftWoodType woodType) {
        if (woodType.getNamespace().equals("minecraft")) {
            tagAccessor.apply(BCTags.Items.BOOKCASES).add((Object)((Item)BCItems.BOOKCASE.get(woodType)));
            tagAccessor.apply(BCTags.Items.FANCY_ARMOR_STANDS_WOOD).add((Object)((Item)BCItems.FANCY_ARMOR_STAND.get(woodType)));
            tagAccessor.apply(BCTags.Items.FANCY_CLOCKS).add((Object)((Item)BCItems.FANCY_CLOCK.get(woodType)));
            tagAccessor.apply(BCTags.Items.FANCY_CRAFTERS).add((Object)((Item)BCItems.FANCY_CRAFTER.get(woodType)));
            tagAccessor.apply(BCTags.Items.GRANDFATHER_CLOCKS).add((Object)((Item)BCItems.GRANDFATHER_CLOCK.get(woodType)));
            tagAccessor.apply(BCTags.Items.LABELS).add((Object)((Item)BCItems.LABEL.get(woodType)));
            tagAccessor.apply(BCTags.Items.POTION_SHELVES).add((Object)((Item)BCItems.POTION_SHELF.get(woodType)));
            tagAccessor.apply(BCTags.Items.SHELVES).add((Object)((Item)BCItems.SHELF.get(woodType)));
            tagAccessor.apply(BCTags.Items.TABLES).add((Object)((Item)BCItems.TABLE.get(woodType)));
            tagAccessor.apply(BCTags.Items.TOOL_RACKS).add((Object)((Item)BCItems.TOOL_RACK.get(woodType)));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.DISPLAY_CASE.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.DISPLAY_CASES));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.SEAT.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEATS));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.SMALL_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_SMALL));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.RAISED_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_RAISED));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.FLAT_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_FLAT));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.TALL_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_TALL));
            DatagenUtil.addAll(BuiltInRegistries.ITEM, BCItems.FANCY_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_FANCY));
        } else {
            tagAccessor.apply(BCTags.Items.BOOKCASES).addOptional(BCItems.BOOKCASE.id(woodType));
            tagAccessor.apply(BCTags.Items.FANCY_ARMOR_STANDS_WOOD).addOptional(BCItems.FANCY_ARMOR_STAND.id(woodType));
            tagAccessor.apply(BCTags.Items.FANCY_CLOCKS).addOptional(BCItems.FANCY_CLOCK.id(woodType));
            tagAccessor.apply(BCTags.Items.FANCY_CRAFTERS).addOptional(BCItems.FANCY_CRAFTER.id(woodType));
            tagAccessor.apply(BCTags.Items.GRANDFATHER_CLOCKS).addOptional(BCItems.GRANDFATHER_CLOCK.id(woodType));
            tagAccessor.apply(BCTags.Items.LABELS).addOptional(BCItems.LABEL.id(woodType));
            tagAccessor.apply(BCTags.Items.POTION_SHELVES).addOptional(BCItems.POTION_SHELF.id(woodType));
            tagAccessor.apply(BCTags.Items.SHELVES).addOptional(BCItems.SHELF.id(woodType));
            tagAccessor.apply(BCTags.Items.TABLES).addOptional(BCItems.TABLE.id(woodType));
            tagAccessor.apply(BCTags.Items.TOOL_RACKS).addOptional(BCItems.TOOL_RACK.id(woodType));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.DISPLAY_CASE.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.DISPLAY_CASES));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.SEAT.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEATS));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.SMALL_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_SMALL));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.RAISED_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_RAISED));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.FLAT_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_FLAT));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.TALL_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_TALL));
            DatagenUtil.addAllOptional(BuiltInRegistries.ITEM, BCItems.FANCY_SEAT_BACK.element(woodType).values(), (TagsProvider.TagAppender)tagAccessor.apply(BCTags.Items.SEAT_BACKS_FANCY));
        }
    }

    @Override
    public void generateLootTablesFor(BlockLootTableProvider provider, BibliocraftWoodType woodType) {
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.BOOKCASE.get(woodType), woodType, DatagenUtil::createNameableTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.FANCY_ARMOR_STAND.get(woodType), woodType, DatagenUtil::createFancyArmorStandTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.FANCY_CLOCK.get(woodType), woodType, DatagenUtil::createDefaultTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.WALL_FANCY_CLOCK.get(woodType), woodType, DatagenUtil::createDefaultTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.FANCY_CRAFTER.get(woodType), woodType, DatagenUtil::createNameableTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.GRANDFATHER_CLOCK.get(woodType), woodType, DatagenUtil::createGrandfatherClockTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.LABEL.get(woodType), woodType, DatagenUtil::createNameableTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.POTION_SHELF.get(woodType), woodType, DatagenUtil::createNameableTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.SHELF.get(woodType), woodType, DatagenUtil::createNameableTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.TABLE.get(woodType), woodType, DatagenUtil::createDefaultTable);
        BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.TOOL_RACK.get(woodType), woodType, DatagenUtil::createNameableTable);
        for (DyeColor color : DyeColor.values()) {
            BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.DISPLAY_CASE.get(woodType, color), woodType, DatagenUtil::createDefaultTable);
            BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.WALL_DISPLAY_CASE.get(woodType, color), woodType, DatagenUtil::createDefaultTable);
            BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.SEAT.get(woodType, color), woodType, DatagenUtil::createDefaultTable);
            BibliocraftDatagenHelperImpl.loot(provider, BCBlocks.SEAT_BACK.get(woodType, color), woodType, block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(ExplosionCondition.survivesExplosion()).add(LootItem.lootTableItem((ItemLike)((ItemLike)BCItems.SMALL_SEAT_BACK.get(woodType, color))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(SeatBackBlock.TYPE, (Comparable)((Object)SeatBackType.SMALL))))).add(LootItem.lootTableItem((ItemLike)((ItemLike)BCItems.RAISED_SEAT_BACK.get(woodType, color))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(SeatBackBlock.TYPE, (Comparable)((Object)SeatBackType.RAISED))))).add(LootItem.lootTableItem((ItemLike)((ItemLike)BCItems.FLAT_SEAT_BACK.get(woodType, color))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(SeatBackBlock.TYPE, (Comparable)((Object)SeatBackType.FLAT))))).add(LootItem.lootTableItem((ItemLike)((ItemLike)BCItems.TALL_SEAT_BACK.get(woodType, color))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(SeatBackBlock.TYPE, (Comparable)((Object)SeatBackType.TALL))))).add(LootItem.lootTableItem((ItemLike)((ItemLike)BCItems.FANCY_SEAT_BACK.get(woodType, color))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(SeatBackBlock.TYPE, (Comparable)((Object)SeatBackType.FANCY)))))));
        }
    }

    @Override
    public void generateRecipesFor(RecipeOutput output, BibliocraftWoodType woodType, String modId) {
        if (!woodType.getNamespace().equals("minecraft")) {
            output = output.withConditions(new ICondition[]{new ModLoadedCondition(woodType.getNamespace())});
        }
        String prefix = "wood/" + woodType.getRegistrationPrefix() + "/";
        Block planks = woodType.family().get().getBaseBlock();
        Block slab = woodType.family().get().get(BlockFamily.Variant.SLAB);
        TagKey stick = Tags.Items.RODS_WOODEN;
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.BOOKCASE.get(woodType), woodType, "bookcases").pattern("PSP").pattern("PSP").pattern("PSP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "bookcase")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.FANCY_ARMOR_STAND.get(woodType), woodType, "fancy_armor_stands").pattern(" R ").pattern(" R ").pattern("SSS").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('R'), Tags.Items.RODS_WOODEN).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "fancy_armor_stand")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.FANCY_CLOCK.get(woodType), woodType, "fancy_clock").pattern("SCS").pattern("SRS").pattern("SIS").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('C'), (ItemLike)Items.CLOCK).define(Character.valueOf('R'), Tags.Items.RODS_WOODEN).define(Character.valueOf('I'), Tags.Items.INGOTS_COPPER).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "fancy_clock")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.FANCY_CRAFTER.get(woodType), woodType, "fancy_crafter").pattern("ITF").pattern("PGP").pattern("PCP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('I'), Tags.Items.DYES_BLACK).define(Character.valueOf('T'), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES).define(Character.valueOf('F'), Tags.Items.FEATHERS).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('C'), (ItemLike)Items.CRAFTER).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "fancy_crafter")));
        BibliocraftDatagenHelperImpl.shapelessRecipe((Item)BCItems.GRANDFATHER_CLOCK.get(woodType), woodType, "grandfather_clock").requires((ItemLike)BCItems.FANCY_CLOCK.get(woodType)).requires((ItemLike)BCItems.FANCY_CLOCK.get(woodType)).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "grandfather_clock")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.LABEL.get(woodType), woodType, "labels").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)slab).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "label")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.POTION_SHELF.get(woodType), woodType, "potion_shelves").pattern("SSS").pattern("P#P").pattern("SSS").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('#'), (ItemLike)Items.GLASS_BOTTLE).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "potion_shelf")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.SHELF.get(woodType), woodType, "shelves").pattern("SSS").pattern(" P ").pattern("SSS").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "shelf")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.TABLE.get(woodType), woodType, "tables").pattern("SSS").pattern(" P ").pattern(" P ").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "table")));
        BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.TOOL_RACK.get(woodType), woodType, "tool_racks").pattern("SSS").pattern("S#S").pattern("SSS").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('#'), Tags.Items.INGOTS_IRON).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "tool_rack")));
        for (DyeColor color : DyeColor.values()) {
            Item wool = (Item)BuiltInRegistries.ITEM.get(BCUtil.mcLoc(color.getName() + "_wool"));
            prefix = "color/" + color.getSerializedName() + "/wood/" + woodType.getRegistrationPrefix() + "/";
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.DISPLAY_CASE.get(woodType, color), woodType, "display_cases").pattern("SGS").pattern("SWS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('W'), (ItemLike)wool).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "display_case")));
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.SEAT.get(woodType, color), woodType, "seats").pattern(" W ").pattern(" S ").pattern("RSR").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('R'), stick).define(Character.valueOf('W'), (ItemLike)wool).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "seat")));
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.SMALL_SEAT_BACK.get(woodType, color), woodType, "small_seat_backs").pattern("W").pattern("S").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('W'), (ItemLike)wool).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "small_seat_back")));
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.RAISED_SEAT_BACK.get(woodType, color), woodType, "raised_seat_backs").pattern(" W ").pattern(" S ").pattern("R R").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('R'), stick).define(Character.valueOf('W'), (ItemLike)wool).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "raised_seat_back")));
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.FLAT_SEAT_BACK.get(woodType, color), woodType, "flat_seat_backs").pattern("RWR").pattern("RSR").pattern("R R").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('R'), stick).define(Character.valueOf('W'), (ItemLike)wool).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "flat_seat_back")));
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.TALL_SEAT_BACK.get(woodType, color), woodType, "tall_seat_backs").pattern("S").pattern("#").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('#'), (ItemLike)BCItems.FLAT_SEAT_BACK.get(woodType, color)).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "tall_seat_back")));
            BibliocraftDatagenHelperImpl.shapedRecipe((Item)BCItems.FANCY_SEAT_BACK.get(woodType, color), woodType, "fancy_seat_backs").pattern("S#S").define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('#'), (ItemLike)BCItems.FLAT_SEAT_BACK.get(woodType, color)).save(output, ResourceLocation.fromNamespaceAndPath((String)modId, (String)(prefix + "fancy_seat_back")));
        }
    }

    private static ResourceLocation bcLoc(String path) {
        return BCUtil.modLoc(path);
    }

    private static void woodenBlockTranslation(LanguageProvider provider, BibliocraftWoodType woodType, WoodTypeDeferredHolder<Block, ?> holder, String suffix) {
        provider.add((Block)holder.get(woodType), DatagenUtil.toTranslation(woodType.getPath()) + " " + suffix);
    }

    private static void coloredWoodenBlockTranslation(LanguageProvider provider, BibliocraftWoodType woodType, DyeColor color, ColoredWoodTypeDeferredHolder<Block, ?> holder, String suffix) {
        provider.add((Block)holder.get(woodType, color), DatagenUtil.toTranslation(color.getName()) + " " + DatagenUtil.toTranslation(woodType.getPath()) + " " + suffix);
    }

    private static void coloredWoodenItemTranslation(LanguageProvider provider, BibliocraftWoodType woodType, DyeColor color, ColoredWoodTypeDeferredHolder<Item, ?> holder, String suffix) {
        provider.add((Item)holder.get(woodType, color), DatagenUtil.toTranslation(color.getName()) + " " + DatagenUtil.toTranslation(woodType.getPath()) + " " + suffix);
    }

    private static void seatBackItemModel(ItemModelProvider provider, SeatBackItem item) {
        provider.withExistingParent(item.getColor().getName() + "_" + item.getWoodType().getRegistrationPrefix() + "_" + item.type.getSerializedName() + "_seat_back", BibliocraftDatagenHelperImpl.bcLoc("block/color/" + item.getColor().getName() + "/wood/" + item.getWoodType().getRegistrationPrefix() + "/" + item.type.getSerializedName() + "_seat_back"));
    }

    private static void loot(BlockLootTableProvider provider, Block block, BibliocraftWoodType woodType, Function<Block, LootTable.Builder> factory) {
        BlockLootTableProvider.WithConditionsBuilder<LootTable.Builder> builder = BlockLootTableProvider.wrapLootTable(factory.apply(block));
        if (!woodType.getNamespace().equals("minecraft")) {
            builder.addCondition(new ICondition[]{new ModLoadedCondition(woodType.getNamespace())});
        }
        provider.add(block, builder);
    }

    private static ShapedRecipeBuilder shapedRecipe(Item item, BibliocraftWoodType woodType, String group) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item).group("bibliocraft:" + group).unlockedBy("has_planks", CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(ItemPredicate.Builder.item().of(new ItemLike[]{woodType.family().get().getBaseBlock()}).build()))));
    }

    private static ShapelessRecipeBuilder shapelessRecipe(Item item, BibliocraftWoodType woodType, String group) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item).group("bibliocraft:" + group).unlockedBy("has_planks", CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(ItemPredicate.Builder.item().of(new ItemLike[]{woodType.family().get().getBaseBlock()}).build()))));
    }

    private static /* synthetic */ ModelFile lambda$generateBlockStatesFor$2(BlockModelProvider models, String finalColorPrefix, ResourceLocation woodTexture, DyeColor color, BlockState state) {
        String suffix = ((SeatBackType)((Object)state.getValue(SeatBackBlock.TYPE))).getSerializedName() + "_seat_back";
        return ((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(finalColorPrefix + suffix, BCUtil.modLoc("block/template/seat/" + suffix))).texture("texture", woodTexture)).texture("color", DatagenUtil.WOOL_TEXTURES.get(color));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$generateBlockStatesFor$1(BlockModelProvider models, String finalColorPrefix, ResourceLocation woodTexture, DyeColor color, BlockState state) {
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)models.withExistingParent(finalColorPrefix + "seat", BibliocraftDatagenHelperImpl.bcLoc("block/template/seat/seat"))).texture("texture", woodTexture)).texture("color", DatagenUtil.WOOL_TEXTURES.get(color))).build();
    }
}

