/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.api.datagen;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.apache.commons.lang3.Validate;

public abstract class BlockLootTableProvider
implements DataProvider {
    private static final Codec<Optional<WithConditions<LootTable>>> CONDITIONAL_CODEC = ConditionalOps.createConditionalCodecWithConditions((Codec)LootTable.DIRECT_CODEC);
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final PackOutput.PathProvider pathProvider;
    private final Map<ResourceKey<LootTable>, WithConditionsBuilder<LootTable.Builder>> map = new HashMap<ResourceKey<LootTable>, WithConditionsBuilder<LootTable.Builder>>();

    public BlockLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createRegistryElementsPathProvider(Registries.LOOT_TABLE);
        this.registries = registries;
    }

    protected abstract void generate();

    public String getName() {
        return "Loot Tables";
    }

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(provider -> this.run(output, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider provider) {
        this.generate();
        Object2ObjectOpenHashMap seeds = new Object2ObjectOpenHashMap();
        return CompletableFuture.allOf((CompletableFuture[])this.map.entrySet().stream().map(arg_0 -> this.lambda$run$2((Map)seeds, output, provider, arg_0)).toArray(CompletableFuture[]::new));
    }

    public void add(Block block, WithConditionsBuilder<LootTable.Builder> builder) {
        this.map.put((ResourceKey<LootTable>)block.getLootTable(), builder);
    }

    public void add(Block block, Function<Block, WithConditionsBuilder<LootTable.Builder>> factory) {
        this.add(block, factory.apply(block));
    }

    public static WithConditionsBuilder<LootTable.Builder> wrapLootTable(LootTable.Builder table) {
        return new WithConditionsBuilder().withCarrier(table);
    }

    private /* synthetic */ CompletableFuture lambda$run$2(Map seeds, CachedOutput output, HolderLookup.Provider provider, Map.Entry entry) {
        WithConditions<LootTable> conditional;
        ResourceLocation location = ((ResourceKey)entry.getKey()).location();
        ResourceLocation sequence = seeds.put(RandomSequence.seedForKey((ResourceLocation)location), location);
        if (sequence != null) {
            Util.logAndPauseIfInIde((String)("Loot table random sequence seed collision on " + String.valueOf(sequence) + " and " + String.valueOf(location)));
        }
        return (conditional = ((WithConditionsBuilder)((Object)entry.getValue())).map(builder -> builder.setRandomSequence(location).setParamSet(LootContextParamSets.BLOCK).build()).build()).conditions().isEmpty() ? DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)provider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)conditional.carrier()), (Path)this.pathProvider.json(location)) : DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)provider, CONDITIONAL_CODEC, Optional.of(conditional), (Path)this.pathProvider.json(location));
    }

    public static class WithConditionsBuilder<T>
    extends WithConditions.Builder<T> {
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private T carrier;

        public WithConditionsBuilder(List<ICondition> conditions) {
            this.conditions.addAll(conditions);
        }

        public WithConditionsBuilder() {
            this(new ArrayList<ICondition>());
        }

        public <N> WithConditionsBuilder<N> map(Function<T, N> mapper) {
            return new WithConditionsBuilder<T>(this.conditions).withCarrier(mapper.apply(this.carrier));
        }

        public WithConditionsBuilder<T> addCondition(Collection<ICondition> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        public WithConditionsBuilder<T> addCondition(ICondition ... conditions) {
            this.conditions.addAll(List.of(conditions));
            return this;
        }

        public WithConditionsBuilder<T> withCarrier(T carrier) {
            this.carrier = carrier;
            return this;
        }

        public WithConditions<T> build() {
            Validate.notNull(this.carrier, (String)"You need to supply a carrier to create a WithConditions", (Object[])new Object[0]);
            return new WithConditions(this.conditions, this.carrier);
        }
    }
}

