/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft;

import com.github.minecraftschurlimods.bibliocraft.Config;
import com.github.minecraftschurlimods.bibliocraft.api.BibliocraftApi;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.init.BCItems;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.github.minecraftschurlimods.bibliocraft.util.init.ColoredDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.init.ColoredWoodTypeDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.init.GroupingDeferredHolder;
import com.github.minecraftschurlimods.bibliocraft.util.init.WoodTypeDeferredHolder;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public final class BibliocraftJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = BCUtil.modLoc("jei_plugin");
    private static final Lazy<BibliocraftWoodType> OAK = Lazy.of(() -> BibliocraftApi.getWoodTypeRegistry().get(BCUtil.mcLoc("oak")));
    private static final DyeColor WHITE = DyeColor.WHITE;
    private static final Component ALL_COLORS = Component.translatable((String)"jei.bibliocraft.all_colors");
    private static final Component ALL_COLORS_AND_WOOD_TYPES = Component.translatable((String)"jei.bibliocraft.all_colors_and_wood_types");
    private static final Component ALL_WOOD_TYPES = Component.translatable((String)"jei.bibliocraft.all_wood_types");
    private static final Lazy<List<WoodTypeDeferredHolder<Item, ?>>> WOOD_TYPE_DEFERRED_HOLDERS = Lazy.of(() -> List.of(BCItems.BOOKCASE, BCItems.FANCY_ARMOR_STAND, BCItems.FANCY_CLOCK, BCItems.FANCY_CRAFTER, BCItems.GRANDFATHER_CLOCK, BCItems.LABEL, BCItems.POTION_SHELF, BCItems.SHELF, BCItems.TABLE, BCItems.TOOL_RACK));
    private static final Lazy<List<ColoredDeferredHolder<Item, ?>>> COLORED_DEFERRED_HOLDERS = Lazy.of(() -> List.of(BCItems.FANCY_GOLD_LAMP, BCItems.FANCY_IRON_LAMP, BCItems.FANCY_GOLD_LANTERN, BCItems.FANCY_IRON_LANTERN));
    private static final Lazy<List<ColoredWoodTypeDeferredHolder<Item, ?>>> COLORED_WOOD_TYPE_DEFERRED_HOLDERS = Lazy.of(() -> List.of(BCItems.DISPLAY_CASE, BCItems.SEAT, BCItems.SMALL_SEAT_BACK, BCItems.RAISED_SEAT_BACK, BCItems.FLAT_SEAT_BACK, BCItems.TALL_SEAT_BACK, BCItems.FANCY_SEAT_BACK));

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)BCItems.SWORD_PEDESTAL.get(), (ISubtypeInterpreter)ColorSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!((Boolean)Config.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
            for (GroupingDeferredHolder holder : (List)WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                registration.addIngredientInfo((ItemLike)((WoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get()), new Component[]{ALL_WOOD_TYPES});
            }
        }
        if (!((Boolean)Config.JEI_SHOW_COLOR_TYPES.get()).booleanValue()) {
            if (!((Boolean)Config.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    registration.addIngredientInfo((ItemLike)((ColoredWoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get(), WHITE), new Component[]{ALL_COLORS_AND_WOOD_TYPES});
                }
            } else {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    for (BibliocraftWoodType woodType : BibliocraftApi.getWoodTypeRegistry().getAll()) {
                        registration.addIngredientInfo((ItemLike)((ColoredWoodTypeDeferredHolder)holder).get(woodType, WHITE), new Component[]{ALL_COLORS});
                    }
                }
            }
            for (GroupingDeferredHolder holder : (List)COLORED_DEFERRED_HOLDERS.get()) {
                registration.addIngredientInfo((ItemLike)((ColoredDeferredHolder)holder).get(WHITE), new Component[]{ALL_COLORS});
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        if (!((Boolean)Config.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
            for (GroupingDeferredHolder holder : (List)WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                this.removeAllExcept(jeiRuntime, holder, (Item)((WoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get()));
            }
        }
        if (!((Boolean)Config.JEI_SHOW_COLOR_TYPES.get()).booleanValue()) {
            if (!((Boolean)Config.JEI_SHOW_WOOD_TYPES.get()).booleanValue()) {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    this.removeAllExcept(jeiRuntime, holder, (Item)((ColoredWoodTypeDeferredHolder)holder).get((BibliocraftWoodType)OAK.get(), WHITE));
                }
            } else {
                for (GroupingDeferredHolder holder : (List)COLORED_WOOD_TYPE_DEFERRED_HOLDERS.get()) {
                    for (BibliocraftWoodType woodType : BibliocraftApi.getWoodTypeRegistry().getAll()) {
                        this.removeAllExcept(jeiRuntime, holder, (Item)((ColoredWoodTypeDeferredHolder)holder).get(woodType, WHITE));
                    }
                }
            }
            for (GroupingDeferredHolder holder : (List)COLORED_DEFERRED_HOLDERS.get()) {
                this.removeAllExcept(jeiRuntime, holder, (Item)((ColoredDeferredHolder)holder).get(WHITE));
            }
        }
    }

    private void removeAllExcept(IJeiRuntime jeiRuntime, GroupingDeferredHolder<Item, ?> holder, Item except) {
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, holder.values().stream().filter(e -> e != except).map(ItemStack::new).toList());
    }

    private static class ColorSubtypeInterpreter
    implements ISubtypeInterpreter<ItemStack> {
        public static final ColorSubtypeInterpreter INSTANCE = new ColorSubtypeInterpreter();

        private ColorSubtypeInterpreter() {
        }

        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return ingredient.has(DataComponents.DYED_COLOR) ? Integer.valueOf(((DyedItemColor)ingredient.get(DataComponents.DYED_COLOR)).rgb()) : null;
        }

        public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
            return ingredient.has(DataComponents.DYED_COLOR) ? String.valueOf(((DyedItemColor)ingredient.get(DataComponents.DYED_COLOR)).rgb()) : "";
        }
    }
}

