/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.entity;

import com.startraveler.bearminimum.Constants;
import com.startraveler.bearminimum.entity.AbstractBearEntity;
import com.startraveler.bearminimum.entity.BearFoodPreferences;
import com.startraveler.bearminimum.entity.goal.AbstractBearAttackPlayersGoal;
import com.startraveler.bearminimum.entity.goal.AbstractBearHurtByTargetGoal;
import com.startraveler.bearminimum.entity.goal.AbstractBearMeleeAttackGoal;
import com.startraveler.bearminimum.entity.goal.ForageGoal;
import com.startraveler.bearminimum.entity.goal.PersonalSpaceTargetGoal;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class BrownBearEntity
extends AbstractBearEntity {
    public static final float WIDTH = 1.8f;
    public static final float HEIGHT = 1.8f;
    public static final TagKey<Biome> HAS_BROWN_BEAR_SPAWNS = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Constants.id("has_brown_bear_spawns"));
    public static final float PERSONAL_SPACE_DISTANCE = 4.0f;
    public static final BearFoodPreferences BROWN_BEAR_FOODS = new BearFoodPreferences(BearFoodPreferences.BROWN_BEAR_FOOD, BearFoodPreferences.BROWN_BEAR_PREY, BearFoodPreferences.BROWN_BEAR_FORAGE);

    public BrownBearEntity(EntityType<? extends BrownBearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.SCALE, 1.0);
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)this.getType().create((Level)level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AbstractBearMeleeAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5, bear -> bear.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, entity -> entity.isUsingItem() && entity.getUseItem().getItem() instanceof InstrumentItem, 12.0f, 1.5, 1.5, entity -> true));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.5, stack -> stack.is(this.getFoodPreferences().foodTag()), true));
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, entity -> !this.isAngry(), 8.0f, 1.5, 1.5, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        this.goalSelector.addGoal(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, Villager.class, entity -> !this.isAngry(), 8.0f, 1.5, 1.5, EntitySelector.NO_CREATIVE_OR_SPECTATOR::test));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new ForageGoal(this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new AbstractBearHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new AbstractBearAttackPlayersGoal(this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((BrownBearEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, entity -> this.wantsMoreFood() && entity.getType().is(this.getFoodPreferences().preyTag())));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
        this.targetSelector.addGoal(7, new PersonalSpaceTargetGoal<Player>((Mob)this, Player.class, 4.0f, 10, true, true, entity -> true));
    }

    @Override
    public BearFoodPreferences getFoodPreferences() {
        return BROWN_BEAR_FOODS;
    }
}

