/*
 * Decompiled with CFR 0.152.
 */
package com.startraveler.bearminimum.client.model;

import com.startraveler.bearminimum.Constants;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.PolarBear;

public class BlackBearModel<T extends PolarBear>
extends QuadrupedModel<T> {
    public static final ModelLayerLocation BODY_LAYER = new ModelLayerLocation(Constants.id("black_bear"), "main");

    public BlackBearModel(ModelPart root) {
        super(root, true, 16.0f, 4.0f, 2.25f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(1, 0).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(1, 44).addBox(-1.5f, 0.0f, -9.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(2.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-4.0f, -4.0f, -4.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)-11.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(4, 21).addBox(-3.5f, -12.0f, -7.0f, 11.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(40, 0).addBox(-3.5f, -23.0f, -7.0f, 11.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)10.0f, (float)12.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(52, 24).addBox(-3.0f, 0.0f, -2.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)16.0f, (float)5.0f));
        PartDefinition leftHindLeg = partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(52, 24).addBox(-1.0f, 0.0f, -2.0f, 4.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)16.0f, (float)5.0f));
        PartDefinition rightFrontLeg = partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(51, 41).addBox(-2.5f, 0.0f, -1.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)16.0f, (float)-7.0f));
        PartDefinition leftFrontLeg = partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(51, 41).addBox(-1.5f, 0.0f, -1.0f, 4.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)16.0f, (float)-7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float partialTick = ageInTicks - (float)((PolarBear)entity).tickCount;
        float standingScaleSquared = entity.getStandingAnimationScale(partialTick);
        standingScaleSquared *= standingScaleSquared;
        float complement = 1.0f - standingScaleSquared;
        this.body.xRot = 1.5707964f - standingScaleSquared * (float)Math.PI * 0.35f;
        this.body.y = 10.0f * complement + 15.0f * standingScaleSquared;
        this.rightFrontLeg.y = 16.0f * complement - 1.0f * standingScaleSquared;
        this.rightFrontLeg.z = -7.0f * complement - 3.0f * standingScaleSquared;
        ModelPart part = this.rightFrontLeg;
        part.xRot -= standingScaleSquared * (float)Math.PI * 0.45f;
        this.leftFrontLeg.y = this.rightFrontLeg.y;
        this.leftFrontLeg.z = this.rightFrontLeg.z;
        part = this.leftFrontLeg;
        part.xRot -= standingScaleSquared * (float)Math.PI * 0.45f;
        if (this.young) {
            this.head.y = 11.0f * complement - 8.0f * standingScaleSquared;
            this.head.z = -12.0f * complement - 8.0f * standingScaleSquared;
        } else {
            this.head.y = 12.0f * complement - 7.0f * standingScaleSquared;
            this.head.z = -11.0f * complement - 1.0f * standingScaleSquared;
        }
        part = this.head;
        part.xRot += standingScaleSquared * (float)Math.PI * 0.15f;
    }
}

