/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.config;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.MutableLoadedConfig;
import net.blay09.mods.balm.api.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.api.config.schema.ConfiguredBoolean;
import net.blay09.mods.balm.api.config.schema.ConfiguredDouble;
import net.blay09.mods.balm.api.config.schema.ConfiguredEnum;
import net.blay09.mods.balm.api.config.schema.ConfiguredFloat;
import net.blay09.mods.balm.api.config.schema.ConfiguredInt;
import net.blay09.mods.balm.api.config.schema.ConfiguredList;
import net.blay09.mods.balm.api.config.schema.ConfiguredLong;
import net.blay09.mods.balm.api.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.api.config.schema.ConfiguredResourceLocation;
import net.blay09.mods.balm.api.config.schema.ConfiguredSet;
import net.blay09.mods.balm.api.config.schema.ConfiguredString;
import net.blay09.mods.balm.api.config.schema.builder.ConfigCategory;
import net.blay09.mods.balm.api.event.ConfigLoadedEvent;
import net.blay09.mods.balm.api.event.ConfigReloadedEvent;
import net.blay09.mods.balm.common.config.AbstractBalmConfig;
import net.blay09.mods.balm.common.config.ConfigLocalization;
import net.blay09.mods.balm.neoforge.config.LoadedNeoForgeConfig;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeBalmConfig
extends AbstractBalmConfig {
    private static final Map<ResourceLocation, Table<String, String, ModConfigSpec.ConfigValue<?>>> properties = new HashMap();
    private static final Map<ResourceLocation, ModConfig> modConfigs = new HashMap<ResourceLocation, ModConfig>();

    private static ModConfigSpec.ConfigValue<?> addPropertyToSpec(ConfiguredProperty<?> property, ModConfigSpec.Builder spec) {
        spec.comment(property.comment());
        spec.translation(ConfigLocalization.forProperty(property));
        ConfiguredProperty<?> configuredProperty = property;
        Objects.requireNonNull(configuredProperty);
        ConfiguredProperty<?> configuredProperty2 = configuredProperty;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfiguredBoolean.class, ConfiguredDouble.class, ConfiguredEnum.class, ConfiguredFloat.class, ConfiguredInt.class, ConfiguredList.class, ConfiguredLong.class, ConfiguredResourceLocation.class, ConfiguredSet.class, ConfiguredString.class}, configuredProperty2, n)) {
            case 0 -> {
                ConfiguredBoolean configuredBoolean = (ConfiguredBoolean)configuredProperty2;
                yield spec.define(configuredBoolean.name(), ((Boolean)configuredBoolean.defaultValue()).booleanValue());
            }
            case 1 -> {
                ConfiguredDouble configuredDouble = (ConfiguredDouble)configuredProperty2;
                yield spec.define(configuredDouble.name(), (Object)((Double)configuredDouble.defaultValue()));
            }
            case 2 -> {
                ConfiguredEnum configuredEnum = (ConfiguredEnum)configuredProperty2;
                yield NeoForgeBalmConfig.defineEnum(spec, configuredEnum);
            }
            case 3 -> {
                ConfiguredFloat configuredFloat = (ConfiguredFloat)configuredProperty2;
                yield spec.define(configuredFloat.name(), (Object)((Float)configuredFloat.defaultValue()).doubleValue());
            }
            case 4 -> {
                ConfiguredInt configuredInt = (ConfiguredInt)configuredProperty2;
                yield spec.define(configuredInt.name(), (Object)((Integer)configuredInt.defaultValue()));
            }
            case 5 -> {
                ConfiguredList configuredList = (ConfiguredList)configuredProperty2;
                yield spec.defineListAllowEmpty(configuredList.name(), NeoForgeBalmConfig.mapConfigCollectionToNeoForge((Collection)configuredList.defaultValue()), () -> NeoForgeBalmConfig.newListElement(configuredList), it -> NeoForgeBalmConfig.validateListElement(configuredList, it));
            }
            case 6 -> {
                ConfiguredLong configuredLong = (ConfiguredLong)configuredProperty2;
                yield spec.define(configuredLong.name(), (Object)((Long)configuredLong.defaultValue()));
            }
            case 7 -> {
                ConfiguredResourceLocation configuredResourceLocation = (ConfiguredResourceLocation)configuredProperty2;
                yield spec.define(configuredResourceLocation.name(), (Object)((ResourceLocation)configuredResourceLocation.defaultValue()).toString());
            }
            case 8 -> {
                ConfiguredSet configuredSet = (ConfiguredSet)configuredProperty2;
                yield spec.defineListAllowEmpty(configuredSet.name(), NeoForgeBalmConfig.mapConfigCollectionToNeoForge((Collection)configuredSet.defaultValue()), () -> NeoForgeBalmConfig.newSetElement(configuredSet), it -> NeoForgeBalmConfig.validateSetElement(configuredSet, it));
            }
            case 9 -> {
                ConfiguredString configuredString = (ConfiguredString)configuredProperty2;
                yield spec.define(configuredString.name(), (Object)((String)configuredString.defaultValue()));
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(property));
        };
    }

    public static List<?> mapConfigCollectionToNeoForge(Collection<?> values) {
        return values.stream().map(NeoForgeBalmConfig::mapConfigValueToNeoForge).toList();
    }

    public static Object mapConfigValueToNeoForge(Object value) {
        List<?> list = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ResourceLocation.class, Float.class, Set.class, List.class}, (Object)list, n)) {
            case 0 -> {
                ResourceLocation resourceLocation = (ResourceLocation)list;
                yield resourceLocation.toString();
            }
            case 1 -> {
                Float floatValue = (Float)((Object)list);
                yield floatValue.doubleValue();
            }
            case 2 -> {
                Set setValue = (Set)((Object)list);
                yield NeoForgeBalmConfig.mapConfigCollectionToNeoForge(setValue);
            }
            case 3 -> {
                List listValue = list;
                yield NeoForgeBalmConfig.mapConfigCollectionToNeoForge(listValue);
            }
            default -> value;
        };
    }

    public static List<?> mapConfigListFromNeoForge(ConfiguredList<?> property, List<?> value) {
        return value.stream().map(it -> NeoForgeBalmConfig.mapConfigValueFromNeoForge(property.nestedType(), it)).toList();
    }

    public static Set<?> mapConfigSetFromNeoForge(ConfiguredSet<?> property, List<?> value) {
        return value.stream().map(it -> NeoForgeBalmConfig.mapConfigValueFromNeoForge(property.nestedType(), it)).collect(Collectors.toSet());
    }

    public static Object mapConfigValueFromNeoForge(ConfiguredProperty<?> property, Object value) {
        ConfiguredProperty<?> configuredProperty = property;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConfiguredResourceLocation.class, ConfiguredFloat.class, ConfiguredList.class, ConfiguredSet.class}, configuredProperty, n)) {
            case 0 -> {
                ConfiguredResourceLocation ignored = (ConfiguredResourceLocation)configuredProperty;
                yield ResourceLocation.parse((String)((String)((Object)value)));
            }
            case 1 -> {
                ConfiguredFloat ignored = (ConfiguredFloat)configuredProperty;
                yield Float.valueOf(((Double)((Object)value)).floatValue());
            }
            case 2 -> {
                ConfiguredList configuredList = (ConfiguredList)configuredProperty;
                yield NeoForgeBalmConfig.mapConfigListFromNeoForge(configuredList, value);
            }
            case 3 -> {
                ConfiguredSet configuredSet = (ConfiguredSet)configuredProperty;
                yield NeoForgeBalmConfig.mapConfigSetFromNeoForge(configuredSet, value);
            }
            default -> value;
        };
    }

    private static Object mapConfigValueFromNeoForge(Class<?> nestedType, Object value) {
        if (nestedType == ResourceLocation.class) {
            return ResourceLocation.parse((String)((String)value));
        }
        if (nestedType == Float.class) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (nestedType.isEnum() && value instanceof String) {
            return NeoForgeBalmConfig.stringToEnum(value, nestedType);
        }
        return value;
    }

    private static <T> T newListElement(ConfiguredList<T> configuredList) {
        return NeoForgeBalmConfig.newCollectionElement(configuredList.nestedType());
    }

    private static <T> T newSetElement(ConfiguredSet<T> configuredSet) {
        return NeoForgeBalmConfig.newCollectionElement(configuredSet.nestedType());
    }

    private static <T> T newCollectionElement(Class<T> nestedType) {
        if (nestedType == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        if (nestedType == Double.class) {
            return (T)Double.valueOf(0.0);
        }
        if (nestedType == Float.class) {
            return (T)Double.valueOf(0.0);
        }
        if (nestedType == Integer.class) {
            return (T)Integer.valueOf(0);
        }
        if (nestedType == Long.class) {
            return (T)Long.valueOf(0L);
        }
        if (nestedType == ResourceLocation.class) {
            return (T)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air").toString();
        }
        if (nestedType == String.class) {
            return (T)"";
        }
        if (nestedType.isEnum()) {
            return nestedType.getEnumConstants()[0];
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(nestedType));
    }

    private static <T> boolean validateListElement(ConfiguredList<T> configuredList, Object value) {
        return NeoForgeBalmConfig.validateCollectionElement(configuredList.nestedType(), value);
    }

    private static <T> boolean validateSetElement(ConfiguredSet<T> configuredSet, Object value) {
        return NeoForgeBalmConfig.validateCollectionElement(configuredSet.nestedType(), value);
    }

    private static <T> boolean validateCollectionElement(Class<T> nestedType, Object value) {
        if (nestedType == Boolean.class) {
            return value instanceof Boolean || "true".equals(value) || "false".equals(value);
        }
        if (nestedType == Double.class) {
            try {
                return value instanceof Double || !Double.isNaN(Double.parseDouble(value.toString()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (nestedType == Float.class) {
            try {
                return value instanceof Float || !Float.isNaN(Float.parseFloat(value.toString()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (nestedType == Integer.class) {
            try {
                if (value instanceof Integer) {
                    return true;
                }
                Integer.parseInt(value.toString());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (nestedType == Long.class) {
            try {
                if (value instanceof Long) {
                    return true;
                }
                Long.parseLong(value.toString());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (nestedType == ResourceLocation.class) {
            return value instanceof String && ResourceLocation.tryParse((String)value.toString()) != null;
        }
        if (nestedType == String.class) {
            return value instanceof String;
        }
        if (nestedType.isEnum()) {
            return value instanceof String && NeoForgeBalmConfig.validateEnum(value, nestedType);
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(nestedType));
    }

    private static <T extends Enum<T>> boolean validateEnum(Object value, Class<?> unknownClass) {
        if (unknownClass.isEnum()) {
            return EnumGetMethod.NAME_IGNORECASE.validate(value, unknownClass);
        }
        throw new IllegalArgumentException("Not an enum class: " + unknownClass.getName());
    }

    private static <T extends Enum<T>> T stringToEnum(Object value, Class<?> unknownClass) {
        if (unknownClass.isEnum()) {
            return (T)EnumGetMethod.NAME_IGNORECASE.get(value, unknownClass);
        }
        throw new IllegalArgumentException("Not an enum class: " + unknownClass.getName());
    }

    private static <T extends Enum<T>> ModConfigSpec.ConfigValue<T> defineEnum(ModConfigSpec.Builder spec, ConfiguredEnum<T> configuredEnum) {
        return spec.defineEnum(configuredEnum.name(), (Enum)configuredEnum.defaultValue(), EnumGetMethod.NAME_IGNORECASE);
    }

    @Override
    public File getConfigDir() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    @Override
    public void registerConfig(BalmConfigSchema schema) {
        String stringType;
        super.registerConfig(schema);
        String namespace = schema.identifier().getNamespace();
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(namespace).orElseThrow(() -> new IllegalStateException("Mod container for " + namespace + " not found when registering config."));
        IEventBus eventBus = modContainer.getEventBus();
        if (eventBus == null) {
            throw new IllegalStateException("Missing event bus for " + schema.identifier().getNamespace() + " when registering config.");
        }
        eventBus.addListener(event -> {
            ModConfig modConfig = event.getConfig();
            ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)modConfig.getModId(), (String)modConfig.getType().extension());
            if (schema.identifier().equals((Object)identifier)) {
                modConfigs.put(schema.identifier(), modConfig);
                LoadedNeoForgeConfig wrappedConfig = new LoadedNeoForgeConfig(schema, modConfig, properties.get(schema.identifier()));
                this.setLocalConfig(schema, wrappedConfig);
                this.setActiveConfig(schema, wrappedConfig);
                Balm.getEvents().fireEvent(new ConfigLoadedEvent(schema));
            }
        });
        eventBus.addListener(event -> {
            ModConfig modConfig = event.getConfig();
            ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)modConfig.getModId(), (String)modConfig.getType().extension());
            if (schema.identifier().equals((Object)identifier)) {
                modConfigs.put(schema.identifier(), modConfig);
                LoadedNeoForgeConfig wrappedConfig = new LoadedNeoForgeConfig(schema, modConfig, properties.get(schema.identifier()));
                this.setLocalConfig(schema, wrappedConfig);
                this.updateActiveFromLocal(schema, wrappedConfig);
                Balm.getEvents().fireEvent(new ConfigReloadedEvent(schema));
            }
        });
        ModConfig.Type configType = switch (stringType = schema.identifier().getPath()) {
            case "common" -> ModConfig.Type.COMMON;
            case "client" -> ModConfig.Type.CLIENT;
            case "startup" -> ModConfig.Type.STARTUP;
            default -> throw new IllegalArgumentException("Unsupported config type: " + stringType + " - only 'common', 'client' and 'startup' are supported.");
        };
        Pair<ModConfigSpec, HashBasedTable<String, String, ModConfigSpec.ConfigValue<?>>> mappedConfigSpec = this.mapToConfigSpec(schema);
        modContainer.registerConfig(configType, (IConfigSpec)mappedConfigSpec.getFirst());
        properties.put(schema.identifier(), (Table)mappedConfigSpec.getSecond());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.initializeConfigurationScreen(modContainer);
        }
    }

    @Override
    public void saveLocalConfig(BalmConfigSchema schema, MutableLoadedConfig config) {
        super.saveLocalConfig(schema, config);
        ModConfig modConfig = modConfigs.get(schema.identifier());
        if (modConfig == null) {
            throw new IllegalStateException("Backing config not available for " + String.valueOf(schema.identifier()));
        }
        LoadedNeoForgeConfig wrappedConfig = new LoadedNeoForgeConfig(schema, modConfig, properties.get(schema.identifier()));
        wrappedConfig.applyFrom(schema, config);
        ((ModConfigSpec)modConfig.getSpec()).save();
    }

    private void initializeConfigurationScreen(ModContainer modContainer) {
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    private Pair<ModConfigSpec, HashBasedTable<String, String, ModConfigSpec.ConfigValue<?>>> mapToConfigSpec(BalmConfigSchema schema) {
        ModConfigSpec.Builder spec = new ModConfigSpec.Builder();
        HashBasedTable properties = HashBasedTable.create();
        for (ConfiguredProperty<?> rootProperty : schema.rootProperties()) {
            properties.put((Object)"", (Object)rootProperty.name(), NeoForgeBalmConfig.addPropertyToSpec(rootProperty, spec));
        }
        for (ConfigCategory category : schema.categories()) {
            spec.push(category.name());
            for (ConfiguredProperty<?> property : category.properties()) {
                properties.put((Object)category.name(), (Object)property.name(), NeoForgeBalmConfig.addPropertyToSpec(property, spec));
            }
            spec.pop();
        }
        return Pair.of((Object)spec.build(), (Object)properties);
    }
}

