/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.navigation;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface ExtendedNavigator {
    public static final float EPSILON = 1.0E-8f;

    public Mob getMob();

    public Path getPath();

    default public boolean canPathOnto(PathType pathType) {
        return switch (pathType) {
            case PathType.WATER, PathType.LAVA, PathType.OPEN -> false;
            default -> true;
        };
    }

    default public boolean canPathInto(PathType pathType) {
        return switch (pathType) {
            case PathType.DAMAGE_FIRE, PathType.DANGER_FIRE, PathType.DAMAGE_OTHER -> true;
            default -> false;
        };
    }

    default public boolean isCloseToNextNode(float distance) {
        Mob mob = this.getMob();
        Path path = this.getPath();
        Vec3 nextNodePos = this.getEntityPosAtNode(path.getNextNodeIndex());
        return Math.abs(mob.getX() - nextNodePos.x) < (double)distance && Math.abs(mob.getZ() - nextNodePos.z) < (double)distance && Math.abs(mob.getY() - nextNodePos.y) < 1.0;
    }

    default public boolean isAboutToTraverseVertically() {
        Mob mob = this.getMob();
        Path path = this.getPath();
        int fromNode = path.getNextNodeIndex();
        int fromNodeHeight = path.getNode((int)fromNode).y;
        int toNode = Math.min(path.getNodeCount(), fromNode + Mth.ceil((double)((double)mob.getBbWidth() * 0.5)) + 1);
        for (int i = fromNode + 1; i < toNode; ++i) {
            if (path.getNode((int)i).y == fromNodeHeight) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Path patchPath(@Nullable Path path) {
        return path == null ? null : new Path(path.nodes, path.getTarget(), path.canReach()){

            public Vec3 getEntityPosAtNode(Entity entity, int nodeIndex) {
                return ExtendedNavigator.this.getEntityPosAtNode(nodeIndex);
            }
        };
    }

    default public PathFinder createSmoothPathFinder(NodeEvaluator nodeEvaluator, int maxVisitedNodes) {
        return new PathFinder(nodeEvaluator, maxVisitedNodes){

            @Nullable
            public Path findPath(PathNavigationRegion navigationRegion, Mob mob, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
                return ExtendedNavigator.this.patchPath(super.findPath(navigationRegion, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier));
            }
        };
    }

    default public boolean attemptShortcut(int targetNode, Vec3 safeSurfacePos) {
        Mob mob = this.getMob();
        Path path = this.getPath();
        Vec3 position = mob.position();
        Vec3 minBounds = safeSurfacePos.add((double)(-mob.getBbWidth()) * 0.5, 0.0, (double)(-mob.getBbWidth()) * 0.5);
        Vec3 maxBounds = minBounds.add((double)mob.getBbWidth(), (double)mob.getBbHeight(), (double)mob.getBbWidth());
        for (int nodeIndex = targetNode - 1; nodeIndex > path.getNextNodeIndex(); --nodeIndex) {
            Vec3 nodeDelta = this.getEntityPosAtNode(nodeIndex).subtract(position);
            if (!this.isCollisionFreeTraversal(nodeDelta, minBounds, maxBounds)) continue;
            path.setNextNodeIndex(nodeIndex);
            return true;
        }
        return false;
    }

    default public Vec3 getEntityPosAtNode(int nodeIndex) {
        Mob mob = this.getMob();
        Path path = this.getPath();
        double lateralOffset = (double)Mth.floor((double)((double)mob.getBbWidth() + 1.0)) / 2.0;
        return Vec3.atLowerCornerOf((Vec3i)path.getNodePos(nodeIndex)).add(lateralOffset, 0.0, lateralOffset);
    }

    default public boolean isCollisionFreeTraversal(Vec3 traversalVector, Vec3 minBoundsPos, Vec3 leadingEdgePos) {
        float traversalDistance = (float)traversalVector.length();
        if (traversalDistance < 1.0E-8f) {
            return true;
        }
        VoxelRayDetails ray = new VoxelRayDetails();
        for (Direction.Axis axis : Direction.Axis.values()) {
            int index = axis.ordinal();
            float axisLength = this.lengthForAxis(traversalVector, axis);
            boolean isPositive = axisLength >= 0.0f;
            float maxPos = this.lengthForAxis(isPositive ? leadingEdgePos : minBoundsPos, axis);
            ray.absStep[index] = isPositive ? 1 : -1;
            ray.minPos[index] = this.lengthForAxis(isPositive ? minBoundsPos : leadingEdgePos, axis);
            ray.leadingEdgeBound[index] = Mth.floor((float)(maxPos - (float)ray.absStep[index] * 1.0E-8f));
            ray.trailingEdgeBound[index] = Mth.floor((float)(ray.minPos[index] + (float)ray.absStep[index] * 1.0E-8f));
            ray.axisLengthNormalised[index] = axisLength / traversalDistance;
            ray.axisSteps[index] = Mth.abs((float)(traversalDistance / axisLength));
            float dist = isPositive ? (float)(ray.leadingEdgeBound[index] + 1) - maxPos : maxPos - (float)ray.leadingEdgeBound[index];
            ray.rayTargetLength[index] = ray.axisSteps[index] < Float.POSITIVE_INFINITY ? ray.axisSteps[index] * dist : Float.POSITIVE_INFINITY;
        }
        return this.collidesWhileTraversing(ray, traversalDistance);
    }

    default public boolean collidesWhileTraversing(VoxelRayDetails ray, float traversalDistance) {
        Mob mob = this.getMob();
        Level level = mob.level();
        try (BulkSectionAccess sectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            NodeEvaluator nodeEvaluator = mob.getNavigation().getNodeEvaluator();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            float target = 0.0f;
            do {
                Direction.Axis longestEdge = ray.rayTargetLength[0] < ray.rayTargetLength[1] ? (ray.rayTargetLength[0] < ray.rayTargetLength[2] ? Direction.Axis.X : Direction.Axis.Z) : (ray.rayTargetLength[1] < ray.rayTargetLength[2] ? Direction.Axis.Y : Direction.Axis.Z);
                int index = longestEdge.ordinal();
                float rayDelta = ray.rayTargetLength[index] - target;
                target = ray.rayTargetLength[index];
                int n = index;
                ray.leadingEdgeBound[n] = ray.leadingEdgeBound[n] + ray.absStep[index];
                int n2 = index;
                ray.rayTargetLength[n2] = ray.rayTargetLength[n2] + ray.axisSteps[index];
                for (Direction.Axis axis : Direction.Axis.values()) {
                    int index2;
                    int n3 = index2 = axis.ordinal();
                    ray.minPos[n3] = ray.minPos[n3] + rayDelta * ray.axisLengthNormalised[index2];
                    ray.trailingEdgeBound[index2] = Mth.floor((float)(ray.minPos[index2] + (float)ray.absStep[index2] * 1.0E-8f));
                }
                int xStep = ray.absStep[0];
                int yStep = ray.absStep[1];
                int zStep = ray.absStep[2];
                int xBound = longestEdge == Direction.Axis.X ? ray.leadingEdgeBound[0] : ray.trailingEdgeBound[0];
                int yBound = longestEdge == Direction.Axis.Y ? ray.leadingEdgeBound[1] : ray.trailingEdgeBound[1];
                int zBound = longestEdge == Direction.Axis.Z ? ray.leadingEdgeBound[2] : ray.trailingEdgeBound[2];
                int xStepBound = ray.leadingEdgeBound[0] + xStep;
                int yStepBound = ray.leadingEdgeBound[1] + yStep;
                int zStepBound = ray.leadingEdgeBound[2] + zStep;
                for (int x = xBound; x != xStepBound; x += xStep) {
                    for (int z = zBound; z != zStepBound; z += zStep) {
                        int y;
                        for (y = yBound; y != yStepBound; y += yStep) {
                            if (sectionAccess.getBlockState((BlockPos)pos.set(x, y, z)).isPathfindable(PathComputationType.LAND)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.canPathOnto(nodeEvaluator.getPathType(new PathfindingContext((CollisionGetter)level, mob), x, yBound - 1, z))) {
                            y = 0;
                            return y != 0;
                        }
                        PathType insidePathType = nodeEvaluator.getPathType(new PathfindingContext((CollisionGetter)level, mob), x, yBound, z);
                        float pathMalus = mob.getPathfindingMalus(insidePathType);
                        if (pathMalus < 0.0f || pathMalus >= 8.0f) {
                            boolean bl = false;
                            return bl;
                        }
                        if (!this.canPathInto(insidePathType)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            } while (target <= traversalDistance);
        }
        return true;
    }

    default public float lengthForAxis(Vec3 vector, Direction.Axis axis) {
        return (float)axis.choose(vector.x, vector.y, vector.z);
    }

    public record VoxelRayDetails(float[] minPos, int[] leadingEdgeBound, int[] trailingEdgeBound, int[] absStep, float[] axisSteps, float[] rayTargetLength, float[] axisLengthNormalised) {
        public VoxelRayDetails() {
            this(new float[3], new int[3], new int[3], new int[3], new float[3], new float[3], new float[3]);
        }
    }
}

