/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;

@Deprecated
public class FollowTemptation<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.IS_TEMPTED, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.REGISTERED)});
    protected BiFunction<E, Player, Float> speedMod = (entity, temptingPlayer) -> Float.valueOf(1.0f);
    protected BiPredicate<E, Player> shouldFollow = (entity, temptingPlayer) -> {
        Animal animal;
        return (!(entity instanceof Animal) || (animal = (Animal)entity).getAge() == 0) && BrainUtils.memoryOrDefault((LivingEntity)entity, MemoryModuleType.IS_PANICKING, () -> false) == false;
    };
    protected BiFunction<E, Player, Float> closeEnoughWhen = (owner, temptingPlayer) -> Float.valueOf(2.5f);
    protected Object2IntFunction<E> temptationCooldown = entity -> 100;

    public FollowTemptation() {
        this.runFor(entity -> Integer.MAX_VALUE);
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public FollowTemptation<E> speedMod(BiFunction<E, Player, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public FollowTemptation<E> followIf(BiPredicate<E, Player> predicate) {
        this.shouldFollow = predicate;
        return this;
    }

    public FollowTemptation<E> closeEnoughDist(BiFunction<E, Player, Float> closeEnoughMod) {
        this.closeEnoughWhen = closeEnoughMod;
        return this;
    }

    public FollowTemptation<E> temptationCooldown(Object2IntFunction<E> cooldownFunction) {
        this.temptationCooldown = cooldownFunction;
        return this;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return this.shouldFollow.test(entity, (Player)BrainUtils.getMemory(entity, MemoryModuleType.TEMPTING_PLAYER));
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, MemoryModuleType.TEMPTING_PLAYER) && !BrainUtils.hasMemory(entity, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS) && !BrainUtils.hasMemory(entity, MemoryModuleType.BREED_TARGET) && this.shouldFollow.test(entity, (Player)BrainUtils.getMemory(entity, MemoryModuleType.TEMPTING_PLAYER));
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.IS_TEMPTED, Boolean.valueOf(true));
    }

    @Override
    protected void tick(E entity) {
        Player temptingPlayer = (Player)BrainUtils.getMemory(entity, MemoryModuleType.TEMPTING_PLAYER);
        float closeEnough = this.closeEnoughWhen.apply(entity, temptingPlayer).floatValue();
        BrainUtils.setMemory(entity, MemoryModuleType.LOOK_TARGET, new EntityTracker((Entity)temptingPlayer, true));
        if (entity.distanceToSqr((Entity)temptingPlayer) < (double)(closeEnough * closeEnough)) {
            BrainUtils.clearMemory(entity, MemoryModuleType.WALK_TARGET);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.WALK_TARGET, new WalkTarget((PositionTracker)new EntityTracker((Entity)temptingPlayer, false), this.speedMod.apply(entity, temptingPlayer).floatValue(), (int)closeEnough));
        }
    }

    @Override
    protected void stop(E entity) {
        int cooldownTicks = (Integer)this.temptationCooldown.apply(entity);
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, Integer.valueOf(cooldownTicks), cooldownTicks);
        BrainUtils.setMemory(entity, MemoryModuleType.IS_TEMPTED, Boolean.valueOf(false));
        BrainUtils.clearMemories(entity, new MemoryModuleType[]{MemoryModuleType.WALK_TARGET, MemoryModuleType.LOOK_TARGET});
    }
}

