/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoCube;
import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzArmorLayer<T extends LivingEntity>
implements AzRenderLayer<T> {
    protected static final HumanoidModel<LivingEntity> INNER_ARMOR_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
    protected static final HumanoidModel<LivingEntity> OUTER_ARMOR_MODEL = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR));
    @Nullable
    protected ItemStack mainHandStack;
    @Nullable
    protected ItemStack offhandStack;
    @Nullable
    protected ItemStack helmetStack;
    @Nullable
    protected ItemStack chestplateStack;
    @Nullable
    protected ItemStack leggingsStack;
    @Nullable
    protected ItemStack bootsStack;

    @Override
    public void preRender(AzRendererPipelineContext<T> context) {
        T t = context.animatable();
        if (!(t instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)t;
        this.mainHandStack = livingEntity.getItemBySlot(EquipmentSlot.MAINHAND);
        this.offhandStack = livingEntity.getItemBySlot(EquipmentSlot.OFFHAND);
        this.helmetStack = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
        this.chestplateStack = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
        this.leggingsStack = livingEntity.getItemBySlot(EquipmentSlot.LEGS);
        this.bootsStack = livingEntity.getItemBySlot(EquipmentSlot.FEET);
    }

    @Override
    public void render(AzRendererPipelineContext<T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        BlockItem blockItem;
        ItemStack armorStack = this.getArmorItemForBone(context, bone);
        if (armorStack == null) {
            return;
        }
        Item item = armorStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(context, bone, armorStack, skullBlock);
        } else {
            this.renderArmor(context, bone, armorStack);
        }
    }

    public void renderArmor(AzRendererPipelineContext<T> context, AzBone bone, ItemStack armorStack) {
        EquipmentSlot slot = this.getEquipmentSlotForBone(context, bone, armorStack);
        AzArmorRenderer renderer = AzArmorRendererRegistry.getOrNull(armorStack);
        HumanoidModel<T> model = this.getModelForItem(armorStack, slot);
        ModelPart modelPart = this.getModelPartForBone(context, bone, model);
        if (!modelPart.cubes.isEmpty()) {
            T t;
            context.poseStack().pushPose();
            context.poseStack().scale(-1.0f, -1.0f, 1.0f);
            if (renderer != null && (t = context.animatable()) instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)t;
                this.prepModelPartForRender(context, bone, modelPart);
                this.renderAzArmorPiece(context, slot, armorStack, renderer, entity, model, modelPart);
            } else if (armorStack.getItem() instanceof ArmorItem) {
                this.prepModelPartForRender(context, bone, modelPart);
                this.renderVanillaArmorPiece(context, bone, slot, armorStack, modelPart);
            }
            context.poseStack().popPose();
        }
    }

    @NotNull
    protected EquipmentSlot getEquipmentSlotForBone(AzRendererPipelineContext<T> context, AzBone bone, ItemStack stack) {
        LivingEntity animatable = (LivingEntity)context.animatable();
        if (animatable instanceof LivingEntity) {
            LivingEntity livingEntity = animatable;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                boolean isHumanoidArmorSlotType;
                boolean bl = isHumanoidArmorSlotType = slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
                if (!isHumanoidArmorSlotType || stack != livingEntity.getItemBySlot(slot)) continue;
                return slot;
            }
        }
        return EquipmentSlot.CHEST;
    }

    @NotNull
    protected ModelPart getModelPartForBone(AzRendererPipelineContext<T> context, AzBone bone, HumanoidModel<?> baseModel) {
        return baseModel.body;
    }

    @Nullable
    protected ItemStack getArmorItemForBone(AzRendererPipelineContext<T> context, AzBone bone) {
        return null;
    }

    protected void renderAzArmorPiece(AzRendererPipelineContext<T> context, EquipmentSlot slot, ItemStack armorStack, AzArmorRenderer renderer, LivingEntity entity, HumanoidModel<T> model, ModelPart modelPart) {
        AzArmorRendererPipeline renderPipelines = renderer.rendererPipeline();
        AzArmorBoneContext boneContext = renderPipelines.context().boneContext();
        AzArmorModel<?> armorModel = renderPipelines.armorModel();
        int i2 = armorStack.is(ItemTags.DYEABLE) ? FastColor.ARGB32.opaque((int)DyedItemColor.getOrDefault((ItemStack)armorStack, (int)-6265536)) : -1;
        renderer.prepForRender((Entity)entity, armorStack, slot, model);
        boneContext.applyBoneVisibilityByPart(slot, modelPart, model);
        armorModel.renderToBuffer(context.poseStack(), null, context.packedLight(), OverlayTexture.NO_OVERLAY, i2);
    }

    protected <I extends Item> void renderVanillaArmorPiece(AzRendererPipelineContext<T> context, AzBone bone, EquipmentSlot slot, ItemStack armorStack, ModelPart modelPart) {
        Holder material = ((ArmorItem)armorStack.getItem()).getMaterial();
        for (ArmorMaterial.Layer layer : ((ArmorMaterial)material.value()).layers()) {
            int color = armorStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)armorStack, (int)-6265536) : -1;
            VertexConsumer buffer = this.getVanillaArmorBuffer(context, armorStack, slot, bone, layer, false);
            modelPart.render(context.poseStack(), buffer, context.packedLight(), context.packedOverlay(), color);
        }
        ArmorTrim trim = (ArmorTrim)armorStack.get(DataComponents.TRIM);
        if (trim != null) {
            TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET).getSprite(slot == EquipmentSlot.LEGS ? trim.innerTexture(material) : trim.outerTexture(material));
            VertexConsumer buffer = sprite.wrap(context.multiBufferSource().getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            modelPart.render(context.poseStack(), buffer, context.packedLight(), context.packedOverlay());
        }
        if (armorStack.hasFoil()) {
            modelPart.render(context.poseStack(), this.getVanillaArmorBuffer(context, armorStack, slot, bone, null, true), context.packedLight(), context.packedOverlay(), Color.WHITE.argbInt());
        }
    }

    protected VertexConsumer getVanillaArmorBuffer(AzRendererPipelineContext<T> context, ItemStack stack, EquipmentSlot slot, AzBone bone, @Nullable ArmorMaterial.Layer layer, boolean forGlint) {
        if (forGlint) {
            return context.multiBufferSource().getBuffer(RenderType.armorEntityGlint());
        }
        return context.multiBufferSource().getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)layer.texture(slot == EquipmentSlot.LEGS)));
    }

    @Nullable
    protected AzArmorRenderer getRendererForItem(ItemStack stack) {
        return AzArmorRendererRegistry.getOrNull(stack);
    }

    protected HumanoidModel<T> getModelForItem(ItemStack stack, EquipmentSlot slot) {
        AzArmorRenderer renderer = this.getRendererForItem(stack);
        if (renderer == null) {
            return slot == EquipmentSlot.LEGS ? INNER_ARMOR_MODEL : OUTER_ARMOR_MODEL;
        }
        return renderer.rendererPipeline().armorModel();
    }

    protected void renderSkullAsArmor(AzRendererPipelineContext<T> context, AzBone bone, ItemStack stack, AbstractSkullBlock skullBlock) {
        SkullBlock.Type type = skullBlock.getType();
        SkullModelBase model = (SkullModelBase)SkullBlockRenderer.createSkullRenderers((EntityModelSet)Minecraft.getInstance().getEntityModels()).get(type);
        RenderType renderType = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)((ResolvableProfile)stack.get(DataComponents.PROFILE)));
        context.poseStack().pushPose();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        context.poseStack().scale(1.1875f, 1.1875f, 1.1875f);
        context.poseStack().translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)context.poseStack(), (MultiBufferSource)context.multiBufferSource(), (int)context.packedLight(), (SkullModelBase)model, (RenderType)renderType);
        context.poseStack().popPose();
    }

    protected void prepModelPartForRender(AzRendererPipelineContext<T> context, AzBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.cubes.getFirst();
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        float actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        float actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        float actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / (double)actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / (double)actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / (double)actualArmorSizeZ);
        sourcePart.setPos(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.xRot = -bone.getRotX();
        sourcePart.yRot = -bone.getRotY();
        sourcePart.zRot = bone.getRotZ();
        context.poseStack().scale(scaleX, scaleY, scaleZ);
    }
}

