/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModel;
import mod.azure.azurelib.rewrite.render.armor.AzArmorModelRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.armor.compat.ShoulderSurfingCompat;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzArmorRendererPipeline
extends AzRendererPipeline<ItemStack> {
    private final AzArmorModel<?> armorModel;
    private final AzArmorRenderer armorRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzArmorRendererPipeline(AzRendererConfig<ItemStack> config, AzArmorRenderer armorRenderer) {
        super(config);
        this.armorModel = new AzArmorModel(this);
        this.armorRenderer = armorRenderer;
    }

    @Override
    protected AzRendererPipelineContext<ItemStack> createContext(AzRendererPipeline<ItemStack> rendererPipeline) {
        return new AzArmorRendererPipelineContext(rendererPipeline);
    }

    @Override
    protected AzModelRenderer<ItemStack> createModelRenderer(AzLayerRenderer<ItemStack> layerRenderer) {
        return new AzArmorModelRenderer(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<ItemStack> createLayerRenderer(AzRendererConfig<ItemStack> config) {
        return new AzLayerRenderer<ItemStack>(config::renderLayers);
    }

    @Override
    protected void updateAnimatedTextureFrame(ItemStack animatable) {
        Entity currentEntity = this.context().currentEntity();
        if (currentEntity != null) {
            AnimatableTexture.setAndUpdate(this.config.textureLocation(animatable));
        }
    }

    @Override
    public void preRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        AzArmorRendererPipelineContext armorContext = (AzArmorRendererPipelineContext)context;
        HumanoidModel<?> baseModel = armorContext.baseModel();
        AzArmorBoneContext boneContext = armorContext.boneContext();
        AzArmorRendererConfig config = this.config();
        EquipmentSlot currentSlot = armorContext.currentSlot();
        float scaleWidth = config.scaleWidth(context.animatable());
        float scaleHeight = config.scaleHeight(context.animatable());
        ItemStack animatable = (ItemStack)armorContext.animatable();
        AzBakedModel model = this.armorRenderer.provider().provideBakedModel(animatable);
        PoseStack poseStack = armorContext.poseStack();
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.armorModel.applyBaseModel(baseModel);
        boneContext.grabRelevantBones(model, config.boneProvider());
        boneContext.applyBaseTransformations(baseModel);
        this.scaleModelForBaby(armorContext, isReRender);
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        boneContext.applyBoneVisibilityBySlot(currentSlot);
        float alphaValue = config.alpha(context.animatable());
        if (ShoulderSurfingCompat.isLoaded() && ShoulderSurfingCompat.getAlpha(armorContext.currentEntity()) < 1.0f) {
            alphaValue = ShoulderSurfingCompat.getAlpha(armorContext.currentEntity());
        }
        if (alphaValue < 1.0f) {
            int alpha = (int)(alphaValue * 255.0f) << 24;
            int color = armorContext.renderColor() & 0xFFFFFF | alpha;
            armorContext.setRenderColor(color);
            armorContext.setTranslucent(true);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    public void scaleModelForBaby(AzArmorRendererPipelineContext context, boolean isReRender) {
        if (!this.armorModel.young || isReRender) {
            return;
        }
        HumanoidModel<?> baseModel = context.baseModel();
        EquipmentSlot currentSlot = context.currentSlot();
        PoseStack poseStack = context.poseStack();
        if (currentSlot == EquipmentSlot.HEAD) {
            if (baseModel.scaleHead) {
                float headScale = 1.5f / baseModel.babyHeadScale;
                poseStack.scale(headScale, headScale, headScale);
            }
            poseStack.translate(0.0f, baseModel.babyYHeadOffset / 16.0f, baseModel.babyZHeadOffset / 16.0f);
        } else {
            float bodyScale = 1.0f / baseModel.babyBodyScale;
            poseStack.scale(bodyScale, bodyScale, bodyScale);
            poseStack.translate(0.0f, baseModel.bodyYOffset / 16.0f, 0.0f);
        }
    }

    public AzArmorModel<?> armorModel() {
        return this.armorModel;
    }

    public AzArmorRendererConfig config() {
        return (AzArmorRendererConfig)super.config();
    }

    public AzArmorRendererPipelineContext context() {
        return (AzArmorRendererPipelineContext)super.context();
    }

    public AzArmorRenderer renderer() {
        return this.armorRenderer;
    }
}

