/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.animation.dispatch.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.common.internal.common.network.packet.AzBlockEntityDispatchCommandPacket;
import mod.azure.azurelib.common.internal.common.network.packet.AzEntityDispatchCommandPacket;
import mod.azure.azurelib.common.internal.common.network.packet.AzItemStackDispatchCommandPacket;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzRootCommandBuilder;
import mod.azure.azurelib.rewrite.animation.dispatch.command.action.AzAction;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import mod.azure.azurelib.rewrite.util.codec.AzListStreamCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public record AzCommand(List<AzAction> actions) {
    public static final StreamCodec<FriendlyByteBuf, AzCommand> CODEC = StreamCodec.composite(new AzListStreamCodec<AzAction>(AzAction.CODEC), AzCommand::actions, AzCommand::new);

    public static AzRootCommandBuilder builder() {
        return new AzRootCommandBuilder();
    }

    public static AzCommand compose(Collection<AzCommand> commands) {
        if (commands.isEmpty()) {
            throw new IllegalArgumentException("Attempted to compose an empty collection of commands.");
        }
        if (commands.size() == 1) {
            return commands.iterator().next();
        }
        return new AzCommand(commands.stream().flatMap(command -> command.actions().stream()).toList());
    }

    public static AzCommand compose(AzCommand first, AzCommand second, AzCommand ... others) {
        ArrayList<AzCommand> allCommands = new ArrayList<AzCommand>();
        allCommands.add(first);
        allCommands.add(second);
        Collections.addAll(allCommands, others);
        return AzCommand.compose(allCommands);
    }

    public static AzCommand create(String controllerName, String animationName) {
        return AzCommand.create(controllerName, animationName, AzPlayBehaviors.PLAY_ONCE);
    }

    public static AzCommand create(String controllerName, String animationName, AzPlayBehavior playBehavior) {
        return AzCommand.builder().playSequence(controllerName, sequenceBuilder -> sequenceBuilder.queue(animationName, props -> props.withPlayBehavior(playBehavior))).build();
    }

    public void sendForEntity(Entity entity) {
        if (entity.level().isClientSide()) {
            this.dispatchFromClient(entity);
        } else {
            int entityId = entity.getId();
            AzEntityDispatchCommandPacket packet = new AzEntityDispatchCommandPacket(entityId, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    public void sendForBlockEntity(BlockEntity entity) {
        if (entity.getLevel().isClientSide()) {
            this.dispatchFromClient(entity);
        } else {
            BlockPos entityBlockPos = entity.getBlockPos();
            AzBlockEntityDispatchCommandPacket packet = new AzBlockEntityDispatchCommandPacket(entityBlockPos, this);
            Services.NETWORK.sendToEntitiesTrackingChunk(packet, (ServerLevel)entity.getLevel(), entityBlockPos);
        }
    }

    public void sendForItem(Entity entity, ItemStack itemStack) {
        if (entity.level().isClientSide()) {
            this.dispatchFromClient(entity);
        } else {
            UUID uuid = (UUID)itemStack.get(AzureLib.AZ_ID.get());
            if (uuid == null) {
                AzureLib.LOGGER.warn("Could not find item stack UUID during dispatch. Did you forget to register an identity for the item? Item: {}, Item Stack: {}", (Object)itemStack.getItem(), (Object)itemStack);
                return;
            }
            AzItemStackDispatchCommandPacket packet = new AzItemStackDispatchCommandPacket(uuid, this);
            Services.NETWORK.sendToTrackingEntityAndSelf(packet, entity);
        }
    }

    private <T> void dispatchFromClient(T animatable) {
        AzAnimator animator = AzAnimatorAccessor.getOrNull(animatable);
        if (animator != null) {
            this.actions.forEach(action -> action.handle(AzDispatchSide.CLIENT, animator));
        }
    }
}

