/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.network.packet;

import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.AzAnimatorAccessor;
import mod.azure.azurelib.rewrite.animation.dispatch.AzDispatchSide;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;

public record AzBlockEntityDispatchCommandPacket(BlockPos blockPos, AzCommand dispatchCommand) implements AbstractPacket
{
    public static final CustomPacketPayload.Type<AzBlockEntityDispatchCommandPacket> TYPE = new CustomPacketPayload.Type(AzureLibNetwork.AZ_BLOCKENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID);
    public static final StreamCodec<FriendlyByteBuf, AzBlockEntityDispatchCommandPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, AzBlockEntityDispatchCommandPacket::blockPos, AzCommand.CODEC, AzBlockEntityDispatchCommandPacket::dispatchCommand, AzBlockEntityDispatchCommandPacket::new);

    @Override
    public void handle() {
        BlockEntity blockEntity = ClientUtils.getLevel().getBlockEntity(this.blockPos);
        if (blockEntity == null) {
            return;
        }
        AzAnimator<BlockEntity> animator = AzAnimatorAccessor.getOrNull(blockEntity);
        if (animator != null) {
            this.dispatchCommand.actions().forEach(action -> action.handle(AzDispatchSide.SERVER, animator));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

