/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.client.config.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mod.azure.azurelib.common.internal.client.config.screen.DialogScreen;
import mod.azure.azurelib.common.internal.common.config.Configurable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public final class ColorWidget
extends AbstractWidget {
    public static final Component SELECT_COLOR = Component.translatable((String)"text.azurelib.screen.color_dialog");
    private final boolean argb;
    private final String colorPrefix;
    private final IntSupplier colorSupplier;
    private final GetSet<String> colorWidget;
    private final Screen lastScreen;

    public ColorWidget(int x, int y, int width, int height, Configurable.Gui.ColorValue colorOptions, GetSet<String> colorWidget, Screen lastScreen) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.argb = colorOptions.isARGB();
        this.colorPrefix = colorOptions.getGuiColorPrefix();
        this.colorWidget = colorWidget;
        this.colorSupplier = () -> {
            String rawColor = (String)colorWidget.get();
            try {
                long longClr = Long.decode(rawColor);
                return (int)longClr;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        };
        this.lastScreen = lastScreen;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialRenderTicks) {
        int borderColor = this.isFocused() ? -1 : -6250336;
        int providedColor = this.colorSupplier.getAsInt();
        int color = this.argb ? providedColor : 0xFF000000 | providedColor;
        graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, borderColor);
        graphics.fillGradient(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -1, -7829368);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, color);
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public void onClick(double mouseX, double mouseY) {
        ColorSelectorDialog dialog = new ColorSelectorDialog(SELECT_COLOR, this.lastScreen, this.argb, this.colorSupplier);
        dialog.onConfirmed(screen -> {
            int color = dialog.getResultColor();
            String colorText = this.colorPrefix + Integer.toHexString(color).toUpperCase(Locale.ROOT);
            this.colorWidget.set(colorText);
            dialog.displayPreviousScreen(dialog);
        });
        Minecraft.getInstance().setScreen((Screen)dialog);
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput elementOutput) {
    }

    public static interface GetSet<T> {
        public static <T> GetSet<T> of(final Supplier<T> get, final Consumer<T> set) {
            return new GetSet<T>(){

                @Override
                public T get() {
                    return get.get();
                }

                @Override
                public void set(T t) {
                    set.accept(t);
                }
            };
        }

        public T get();

        public void set(T var1);
    }

    private static final class ColorSelectorDialog
    extends DialogScreen {
        private final boolean argb;
        private final IntSupplier colorProvider;
        private final List<ColorSlider> sliders = new ArrayList<ColorSlider>();

        public ColorSelectorDialog(Component title, Screen background, boolean allowTransparency, IntSupplier colorProvider) {
            super(title, new Component[0], background);
            this.argb = allowTransparency;
            this.colorProvider = colorProvider;
        }

        @Override
        protected void init() {
            this.sliders.clear();
            int width = 190;
            int height = 120;
            int rightMargin = 85;
            if (this.argb) {
                height = 150;
                rightMargin = 110;
                width = 230;
            }
            super.init();
            this.setDimensions(width, height);
            int color = this.colorProvider.getAsInt();
            this.sliders.add((ColorSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 20, this.dialogWidth - rightMargin, 20, color, ColorComponent.RED)));
            this.sliders.add((ColorSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 45, this.dialogWidth - rightMargin, 20, color, ColorComponent.GREEN)));
            this.sliders.add((ColorSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 70, this.dialogWidth - rightMargin, 20, color, ColorComponent.BLUE)));
            if (this.argb) {
                this.sliders.add((ColorSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 95, this.dialogWidth - rightMargin, 20, color, ColorComponent.ALPHA)));
            }
            this.addRenderableWidget((GuiEventListener)new ColorDisplay(this.dialogLeft + 5 + this.dialogWidth - rightMargin + 5, this.dialogTop + 20, rightMargin - 15, rightMargin - 15, this.argb, this::getResultColor));
            super.addDefaultDialogButtons();
        }

        @Override
        protected void addDefaultDialogButtons() {
        }

        public int getResultColor() {
            int color = 0;
            for (ColorSlider slider : this.sliders) {
                color |= slider.getColor();
            }
            return color;
        }

        private static final class ColorSlider
        extends AbstractSliderButton {
            private final ColorComponent colorComponent;

            public ColorSlider(int x, int y, int width, int height, int color, ColorComponent colorComponent) {
                super(x, y, width, height, CommonComponents.EMPTY, (double)colorComponent.getByteColor(color) / 255.0);
                this.colorComponent = colorComponent;
                this.updateMessage();
            }

            protected void updateMessage() {
                Component colorLabel = this.colorComponent.updateTitle(this.value);
                this.setMessage(colorLabel);
            }

            protected void applyValue() {
            }

            int getColor() {
                return this.colorComponent.getOffsetColor((int)(255.0 * this.value));
            }
        }

        private static enum ColorComponent {
            ALPHA(24),
            RED(16),
            GREEN(8),
            BLUE(0);

            private final int bitOffset;
            private final Function<Double, Component> title;

            private ColorComponent(int bitOffset) {
                this.bitOffset = bitOffset;
                this.title = val -> {
                    String name = this.name().toLowerCase(Locale.ROOT);
                    String translate = "text.azurelib.screen.color." + name;
                    int colorValue = (int)(val * 255.0);
                    return Component.translatable((String)translate, (Object[])new Object[]{colorValue});
                };
            }

            public int getOffsetColor(int value) {
                return value << this.bitOffset;
            }

            public int getByteColor(int value) {
                return value >> this.bitOffset & 0xFF;
            }

            public Component updateTitle(double sliderValue) {
                return this.title.apply(sliderValue);
            }
        }

        private static final class ColorDisplay
        extends AbstractWidget {
            private final boolean argb;
            private final IntSupplier colorProvider;

            public ColorDisplay(int x, int y, int width, int height, boolean argb, IntSupplier colorProvider) {
                super(x, y, width, height, CommonComponents.EMPTY);
                this.argb = argb;
                this.colorProvider = colorProvider;
            }

            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                int color = this.colorProvider.getAsInt();
                if (!this.argb) {
                    color |= 0xFF000000;
                }
                int borderColor = -6250336;
                graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, borderColor);
                graphics.fillGradient(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, -1, -7829368);
                graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, color);
            }

            protected boolean isValidClickButton(int button) {
                return false;
            }

            public void updateWidgetNarration(NarrationElementOutput p_169152_) {
            }
        }
    }
}

