/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.atlasapi.internal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import io.redspace.atlasapi.api.AssetHandler;
import io.redspace.atlasapi.api.AtlasApiRegistry;
import io.redspace.atlasapi.internal.PassthroughBakedModel;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;

public class SimpleAtlasModel
implements IUnbakedGeometry<SimpleAtlasModel> {
    private final BlockModel unbakedGeometry;
    private final Holder<AssetHandler> handler;

    public SimpleAtlasModel(BlockModel unbakedGeometry, Holder<AssetHandler> handler) {
        this.unbakedGeometry = unbakedGeometry;
        this.handler = handler;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new PassthroughBakedModel((model, stack, levevl, entity, seed) -> {
            HashMap<String, Either> map = new HashMap<String, Either>(this.unbakedGeometry.textureMap);
            map.forEach((string, mat) -> this.unbakedGeometry.textureMap.put(string, mat.mapBoth(material -> new Material(((AssetHandler)this.handler.value()).getAtlasLocation(), material.texture()), Function.identity())));
            return new BakedHolder(this.handler, this.unbakedGeometry.bake(baker, m -> ((AssetHandler)this.handler.value()).getSprite(m.texture()), modelState));
        }, baker);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.unbakedGeometry.resolveParents(modelGetter);
    }

    public static class BakedHolder
    implements BakedModel {
        BakedModel model;
        private final Holder<AssetHandler> handler;

        public BakedHolder(Holder<AssetHandler> handler, BakedModel bakedModel) {
            this.model = bakedModel;
            this.handler = handler;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
            return this.model.getQuads(pState, pDirection, pRandom);
        }

        public boolean useAmbientOcclusion() {
            return this.model.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.model.isGui3d();
        }

        public boolean usesBlockLight() {
            return this.model.usesBlockLight();
        }

        public boolean isCustomRenderer() {
            return this.model.isCustomRenderer();
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.model.getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return this.model.getOverrides();
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            return List.of(RenderType.entityCutout((ResourceLocation)((AssetHandler)this.handler.value()).getAtlasLocation()));
        }

        public ItemTransforms getTransforms() {
            return this.model.getTransforms();
        }
    }

    public static final class Loader
    implements IGeometryLoader<SimpleAtlasModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public SimpleAtlasModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            try {
                BlockModel baseModel = new BlockModel.Deserializer().deserialize((JsonElement)jsonObject, BlockModel.class, deserializationContext);
                String typestring = jsonObject.get("handler").getAsString();
                Holder.Reference type = AtlasApiRegistry.ASSET_HANDLER_REGISTRY.getHolderOrThrow(ResourceKey.create(AtlasApiRegistry.ASSET_HANDLER_REGISTRY_KEY, (ResourceLocation)ResourceLocation.parse((String)typestring)));
                return new SimpleAtlasModel(baseModel, (Holder<AssetHandler>)type);
            }
            catch (Exception e) {
                throw new JsonParseException(e.getMessage());
            }
        }
    }
}

