/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.atlasapi.api;

import io.redspace.atlasapi.api.AtlasApiHelper;
import io.redspace.atlasapi.api.AtlasApiRegistry;
import io.redspace.atlasapi.api.data.BakingPreparations;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AssetHandler {
    @NotNull
    public abstract List<SpriteSource> buildSpriteSources();

    @NotNull
    public abstract BakingPreparations makeBakedModelPreparations(ItemStack var1, @Nullable ClientLevel var2, @Nullable LivingEntity var3, int var4);

    public final ResourceLocation getAtlasLocation() {
        return Objects.requireNonNull(AtlasApiRegistry.ASSET_HANDLER_REGISTRY.getKey((Object)this)).withPrefix("atlas/");
    }

    public TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return AtlasApiHelper.getAtlas(this).getSprite(resourceLocation);
    }

    public abstract int modelId(ItemStack var1, @Nullable ClientLevel var2, @Nullable LivingEntity var3, int var4);
}

