/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.impl.client.models;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.AthenaQuad;
import earth.terrarium.athena.api.client.utils.AppearanceAndTintGetter;
import earth.terrarium.athena.api.client.utils.AthenaUtils;
import earth.terrarium.athena.api.client.utils.CtmUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class PanePillarBlockModel
implements AthenaBlockModel {
    public static final AthenaModelFactory FACTORY = new Factory();
    private static final List<AthenaQuad> MIDDLE = List.of(new AthenaQuad(6, 0.4375f, 0.5625f, 1.0f, 0.0f, Rotation.NONE, 0.4375f));
    private final Int2ObjectMap<Material> materials;
    private static final AthenaQuad TOP_MIDDLE = new AthenaQuad(5, 0.4375f, 0.5625f, 0.5625f, 0.4375f, Rotation.NONE, 0.0f, false);
    private static final AthenaQuad NORTH = new AthenaQuad(5, 0.4375f, 0.5625f, 1.0f, 0.5625f, Rotation.NONE, 0.0f, false);
    private static final AthenaQuad SOUTH = new AthenaQuad(5, 0.4375f, 0.5625f, 0.4375f, 0.0f, Rotation.NONE, 0.0f, false);
    private static final AthenaQuad EAST = new AthenaQuad(5, 0.5625f, 1.0f, 0.5625f, 0.4375f, Rotation.NONE, 0.0f, false);
    private static final AthenaQuad WEST = new AthenaQuad(5, 0.0f, 0.4375f, 0.5625f, 0.4375f, Rotation.NONE, 0.0f, false);

    public PanePillarBlockModel(Int2ObjectMap<Material> materials) {
        this.materials = materials;
    }

    @Override
    public List<AthenaQuad> getQuads(AppearanceAndTintGetter level, BlockState state, BlockPos pos, Direction direction) {
        int texture;
        boolean belowState;
        if (direction.getAxis().isVertical()) {
            if (level.getBlockState(pos.relative(direction)) == state) {
                return List.of();
            }
            return this.getTopQuad(state, direction.getAxisDirection());
        }
        boolean rightState = AthenaUtils.getFromDir(state, direction.getCounterClockWise());
        boolean leftState = AthenaUtils.getFromDir(state, direction.getClockWise());
        BlockState upBlockState = level.getAppearance(pos.above(), direction, state, pos);
        BlockState downBlockState = level.getAppearance(pos.below(), direction, state, pos);
        boolean upState = upBlockState.is(state.getBlock()) && AthenaUtils.getFromDir(upBlockState, direction.getCounterClockWise()) && AthenaUtils.getFromDir(upBlockState, direction.getClockWise());
        boolean bl = belowState = downBlockState.is(state.getBlock()) && AthenaUtils.getFromDir(downBlockState, direction.getCounterClockWise()) && AthenaUtils.getFromDir(downBlockState, direction.getClockWise());
        int n = upState && belowState ? 2 : (upState ? 3 : (texture = belowState ? 1 : 4));
        if (leftState && rightState) {
            float min = AthenaUtils.getFromDir(state, direction) ? 0.4375f : 0.5f;
            return List.of(new AthenaQuad(texture, 0.0f, min, 1.0f, 0.5f, Rotation.NONE, 0.4375f), new AthenaQuad(texture, 1.0f - min, 1.0f, 1.0f, 0.5f, Rotation.NONE, 0.4375f), new AthenaQuad(texture, 0.0f, min, 0.5f, 0.0f, Rotation.NONE, 0.4375f), new AthenaQuad(texture, 1.0f - min, 1.0f, 0.5f, 0.0f, Rotation.NONE, 0.4375f));
        }
        if (leftState) {
            float min = AthenaUtils.getFromDir(state, direction) ? 0.5625f : 0.4375f;
            return List.of(new AthenaQuad(0, 0.0f, 1.0f - min, 1.0f, 0.0f, Rotation.NONE, 0.4375f));
        }
        if (rightState) {
            float min = AthenaUtils.getFromDir(state, direction) ? 0.5625f : 0.4375f;
            return List.of(new AthenaQuad(0, min, 1.0f, 1.0f, 0.0f, Rotation.NONE, 0.4375f));
        }
        if (level.getBlockState(pos.relative(direction)).getBlock() != state.getBlock() && !AthenaUtils.getFromDir(state, direction)) {
            return MIDDLE;
        }
        return List.of();
    }

    @Override
    public Int2ObjectMap<TextureAtlasSprite> getTextures(Function<Material, TextureAtlasSprite> getter) {
        Int2ObjectArrayMap textures = new Int2ObjectArrayMap();
        for (Int2ObjectMap.Entry entry : this.materials.int2ObjectEntrySet()) {
            textures.put(entry.getIntKey(), (Object)getter.apply((Material)entry.getValue()));
        }
        return textures;
    }

    private List<AthenaQuad> getTopQuad(BlockState state, Direction.AxisDirection direction) {
        boolean north = AthenaUtils.getFromDir(state, Direction.NORTH);
        boolean south = AthenaUtils.getFromDir(state, Direction.SOUTH);
        boolean east = AthenaUtils.getFromDir(state, Direction.EAST);
        boolean west = AthenaUtils.getFromDir(state, Direction.WEST);
        if (direction == Direction.AxisDirection.NEGATIVE) {
            boolean tempNorth = north;
            north = south;
            south = tempNorth;
        }
        ArrayList<AthenaQuad> quads = new ArrayList<AthenaQuad>();
        quads.add(TOP_MIDDLE);
        if (north) {
            quads.add(NORTH);
        }
        if (south) {
            quads.add(SOUTH);
        }
        if (east) {
            quads.add(EAST);
        }
        if (west) {
            quads.add(WEST);
        }
        return quads;
    }

    private static class Factory
    implements AthenaModelFactory {
        private Factory() {
        }

        @Override
        public Supplier<AthenaBlockModel> create(JsonObject json) {
            Int2ObjectMap<Material> materials = Factory.parseMaterials(GsonHelper.getAsJsonObject((JsonObject)json, (String)"ctm_textures"));
            return () -> new PanePillarBlockModel(materials);
        }

        private static Int2ObjectMap<Material> parseMaterials(JsonObject json) {
            Int2ObjectArrayMap materials = new Int2ObjectArrayMap();
            materials.put(0, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"particle")));
            materials.put(4, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"self")));
            materials.put(1, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"top")));
            materials.put(2, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"center")));
            materials.put(3, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"bottom")));
            materials.put(5, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"edge", (String)GsonHelper.getAsString((JsonObject)json, (String)"particle"))));
            materials.put(6, (Object)CtmUtils.blockMat(GsonHelper.getAsString((JsonObject)json, (String)"side_edge", (String)GsonHelper.getAsString((JsonObject)json, (String)"particle"))));
            return materials;
        }
    }
}

