/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.athena.api.client.utils;

import com.google.gson.JsonObject;
import earth.terrarium.athena.api.client.models.AthenaBlockModel;
import earth.terrarium.athena.api.client.models.AthenaModelFactory;
import earth.terrarium.athena.api.client.models.NotNullUnbakedModel;
import earth.terrarium.athena.impl.loading.AthenaResourceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AthenaUnbakedModelLoader {
    private final ResourceLocation id;
    private final AthenaModelFactory factory;
    private final Function<Supplier<AthenaBlockModel>, NotNullUnbakedModel> loader;

    public AthenaUnbakedModelLoader(ResourceLocation id, AthenaModelFactory factory, Function<Supplier<AthenaBlockModel>, NotNullUnbakedModel> loader) {
        this.id = id;
        this.factory = factory;
        this.loader = loader;
    }

    @Nullable
    public NotNullUnbakedModel loadModel(ModelResourceLocation modelId) {
        if (modelId == null || "inventory".equals(modelId.getVariant())) {
            return null;
        }
        JsonObject json = AthenaResourceLoader.getData(this.id, modelId.id());
        return this.loadModel(json);
    }

    public NotNullUnbakedModel loadModel(JsonObject json) {
        if (json != null) {
            return this.loader.apply(this.factory.create(json));
        }
        return null;
    }
}

