/*
 * Decompiled with CFR 0.152.
 */
package artifacts.neoforge.network;

import artifacts.network.NetworkHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetworkHandler {
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        for (NetworkHandler.PayloadHandler<?> payloadHandler : NetworkHandler.SERVERBOUND_HANDLERS) {
            if (NetworkHandler.CLIENTBOUND_HANDLERS.stream().anyMatch(p -> p.type() == payloadHandler.type())) {
                NeoForgeNetworkHandler.register((arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playBidirectional(arg_0, arg_1, arg_2), payloadHandler);
                continue;
            }
            NeoForgeNetworkHandler.register((arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playToServer(arg_0, arg_1, arg_2), payloadHandler);
        }
        for (NetworkHandler.PayloadHandler<?> payloadHandler : NetworkHandler.CLIENTBOUND_HANDLERS) {
            if (!NetworkHandler.SERVERBOUND_HANDLERS.stream().noneMatch(p -> p.type() == payloadHandler.type())) continue;
            NeoForgeNetworkHandler.register((arg_0, arg_1, arg_2) -> ((PayloadRegistrar)registrar).playToClient(arg_0, arg_1, arg_2), payloadHandler);
        }
    }

    private static <T extends CustomPacketPayload> void register(PayloadRegistration registration, NetworkHandler.PayloadHandler<T> payloadHandler) {
        StreamCodec<RegistryFriendlyByteBuf, T> codec = payloadHandler.codec();
        registration.register(payloadHandler.type(), codec, (arg, context) -> payloadHandler.receiver().receive(arg, new NeoForgePayloadContext(context.player(), context)));
    }

    @FunctionalInterface
    private static interface PayloadRegistration {
        public <T extends CustomPacketPayload> void register(CustomPacketPayload.Type<T> var1, StreamCodec<? super FriendlyByteBuf, T> var2, IPayloadHandler<T> var3);
    }

    private record NeoForgePayloadContext(Player player, IPayloadContext context) implements NetworkHandler.PayloadContext
    {
        @Override
        public void queue(Runnable runnable) {
            this.context.enqueueWork(runnable);
        }
    }
}

