/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.TickingAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public record CureEffects(Value<Boolean> enabled, Value<Integer> maxEffectDuration) implements EquipmentAbility,
TickingAbility
{
    public static final Codec<CureEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.enabledField().forGetter(CureEffects::enabled), (App)ValueTypes.DURATION.codec().fieldOf("duration").forGetter(CureEffects::maxEffectDuration)).apply((Applicative)instance, CureEffects::new));
    public static final StreamCodec<ByteBuf, CureEffects> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), CureEffects::enabled, ValueTypes.DURATION.streamCodec(), CureEffects::maxEffectDuration, CureEffects::new);

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }

    @Override
    public void wornTick(LivingEntity entity, boolean isOnCooldown, boolean isDisabled) {
        if (isDisabled || !this.isNonCosmetic()) {
            return;
        }
        HashMap<Holder, MobEffectInstance> effects = new HashMap<Holder, MobEffectInstance>();
        int maxEffectDuration = (Integer)this.maxEffectDuration().get() * 20;
        entity.getActiveEffectsMap().forEach((effect, instance) -> {
            if (ModTags.isInTag((MobEffect)effect.value(), ModTags.ANTIDOTE_VESSEL_CANCELLABLE) && !instance.endsWithin(maxEffectDuration) && !instance.isInfiniteDuration()) {
                effects.put((Holder)effect, (MobEffectInstance)instance);
            }
        });
        effects.forEach((effect, instance) -> {
            entity.removeEffectNoUpdate(effect);
            if (maxEffectDuration > 0) {
                entity.addEffect(new MobEffectInstance(effect, maxEffectDuration, instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon()));
            }
        });
    }
}

