/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.mimic.model;

import artifacts.Artifacts;
import artifacts.client.mimic.model.MimicModel;
import artifacts.entity.MimicEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;

public class MimicChestLayerModel
extends EntityModel<MimicEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Artifacts.id("mimic_overlay"), "mimic_overlay");
    protected final ModelPart bottom;
    protected final ModelPart lid;

    public MimicChestLayerModel(ModelPart part) {
        this.bottom = part.getChild("bottom");
        this.lid = part.getChild("lid");
    }

    public void setupAnim(MimicEntity mimic, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks) {
        MimicModel.setChestRotations(mimic, partialTicks, this.lid, this.bottom);
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.bottom.render(matrixStack, buffer, packedLight, packedOverlay, color);
        this.lid.render(matrixStack, buffer, packedLight, packedOverlay, color);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        mesh.getRoot().addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, -9.0f, 0.0f, 14.0f, 10.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        mesh.getRoot().addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f).texOffs(0, 0).addBox(7.0f, -2.0f, 14.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

